/*
 * Copyright (c) 2014, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: Model.java 73483 2014-02-12 19:57:06Z supol $ 
 */

package com.sun.ts.tests.jaxrs.api.rs.core.linkjaxbadapter;

import javax.ws.rs.core.Link;
import javax.ws.rs.ext.RuntimeDelegate;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public class Model {

	public Model(Link link) {
		super();
		this.link = link;
	}

	public Model() {
		link = RuntimeDelegate.getInstance().createLinkBuilder()
				.uri("default://constructor.model/was/used").build();
	}
	
	@XmlElement
	@XmlJavaTypeAdapter(JaxbAdapterEx.class)	
	Link link;

	public Link getLink() {
		return link;
	}

	public void setLink(Link lnk) {
		link = lnk;
	}	
}
