/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id$
 */
package com.sun.ts.tests.jaxrs.ee.rs;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

@Provider
public class WebApplicationExceptionMapper implements
		ExceptionMapper<WebApplicationException> {

	@Override
	public Response toResponse(WebApplicationException exception) {
		Response response = exception.getResponse();
		Status status = Status.fromStatusCode(response.getStatus());
		StringBuilder sb = new StringBuilder();
		// Note mapper applied
		sb.append(getClass().getSimpleName());
		// note what status there might have been
		if (status != null)
			sb.append("|status=").append(status.name());
		// Note what source exceptions there might have been
		for (Throwable t = exception.getCause(); t != null; t = t.getCause()) {
			sb.append("|msg=").append(t.getMessage());
			sb.append("|ex=").append(t.getClass().getName());
		}
		return Response.ok(sb.toString()).build();
	}

}
