/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id$ 
 */

package com.sun.ts.tests.jaxrs.ee.rs.ext.interceptor.clientwriter;

import java.io.IOException;

import com.sun.ts.tests.jaxrs.api.rs.ext.interceptor.TemplateInterceptorBody;
import com.sun.ts.tests.jaxrs.common.client.JaxrsCommonClient;

/**
 * Client with given ContextOperation enum, so that an enum name is passed as 
 * a http header to an interceptor. Due to the ContextOperation, the proper 
 * method on an interceptor is called.  
 * @param <CONTEXTOPERATION>
 */
public abstract class WriterClient<CONTEXTOPERATION extends Enum<?>> extends
		JaxrsCommonClient {

	private static final long serialVersionUID = 8110273180216593061L;

	/**
	 * Set the header OPERATION to a proper value
	 * Also set the entity, it is good as it is here for most of the tests.
	 * For the rest, the entity needs to be replaced.
	 */
	protected void setOperationAndEntity(CONTEXTOPERATION op){
		addHeader(TemplateInterceptorBody.OPERATION, op.name());
		setRequestContentEntity(TemplateInterceptorBody.ENTITY);
	}

	/**
	 * Invoke and convert IOException to Fault
	 */
	protected void invoke() throws Fault {
		try {
			setProperty(Property.REQUEST, buildRequest(Request.POST, ""));
			super.invoke();
		} catch (Exception cause) {
			if (cause instanceof IOException)
				throw new Fault(cause.getMessage());
			else
				throw new Fault(cause);
		}
	}

	/**
	 * Register providers to client configuration
	 * @param response
	 *            ClientRequestFilter#abortWith response
	 */
	protected abstract void addProviders();
}
