/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id$
 */

package com.sun.ts.tests.jaxrs.ee.rs.ext.paramconverter;

import javax.activation.DataSource;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ParamConverter;

import com.sun.ts.tests.jaxrs.common.impl.StringDataSource;

public class DataSourceParamConverter implements ParamConverter<DataSource> {

	@Override
	public DataSource fromString(String value) throws IllegalArgumentException {
		StringDataSource sds = new StringDataSource(value,
				MediaType.TEXT_PLAIN_TYPE);
		return sds;
	}

	@Override
	public String toString(DataSource value) throws IllegalArgumentException {
		return value.getName();
	}

}
