/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: ParamConverterProviderOne.java 75010 2017-05-30 19:45:08Z jsupol $ 
 */

package com.sun.ts.tests.jaxrs.jaxrs21.ee.priority;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

import javax.annotation.Priority;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import javax.ws.rs.ext.Provider;

@Provider
@Priority(88)
public class ParamConverterProviderOne implements ParamConverterProvider {

	@Override
	public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
		return new ParamConverter<T>() {

			@SuppressWarnings("unchecked")
			@Override
			public T fromString(String value) {
				if (String.class == rawType)
					return (T) getClass().getName();
				return null;
			}

			@Override
			public String toString(T value) {
				return getClass().getName();
			}

		};
	}

}
