/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: AddTenGlobalInterceptor.java 69965 2013-02-13 12:02:10Z supol $  
 */

package com.sun.ts.tests.jaxrs.spec.filter.exception;

import java.io.IOException;

import javax.annotation.Priority;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.ReaderInterceptorContext;

@Provider
@Priority(500)
public class AddTenGlobalInterceptor extends AbstractAddInterceptor {

	public static final String EXCEPTION_FIRING_HEADER = "AddTenInterceptorThrowsException";

	public AddTenGlobalInterceptor() {
		super(10);
	}

	@Override
	public Object aroundReadFrom(ReaderInterceptorContext context)
			throws IOException, WebApplicationException {
		String header = context.getHeaders().getFirst(EXCEPTION_FIRING_HEADER);
		if (header != null)
			throw new RuntimeException(header);
		return super.aroundReadFrom(context);
	}
}
