/*
 * Copyright (c) 2012, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id: StringReader.java 69965 2013-02-13 12:02:10Z supol $
 */

package com.sun.ts.tests.jaxrs.spec.provider.visibility;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;

@Provider
@Consumes("text/tck")
public class StringReader implements MessageBodyReader<String> {
	private HttpHeaders headers;
	private UriInfo info;
	private Application application;
	private Request request;
	private Providers provider;

	protected StringReader(@Context HttpHeaders headers, @Context UriInfo info,
			@Context Application application, @Context Request request,
			@Context Providers provider) {
		super();
		this.headers = headers;
		this.info = info;
		this.application = application;
		this.request = request;
		this.provider = provider;
	}

	public StringReader(@Context HttpHeaders headers, @Context UriInfo info,
			@Context Application application, @Context Request request) {
		super();
		this.headers = headers;
		this.info = info;
		this.application = application;
		this.request = request;
	}

	public StringReader(@Context HttpHeaders headers, @Context UriInfo info,
			@Context Application application) {
		super();
		this.headers = headers;
		this.info = info;
		this.application = application;
	}

	public StringReader(@Context HttpHeaders headers, @Context UriInfo info) {
		super();
		this.headers = headers;
		this.info = info;
	}

	public StringReader(@Context HttpHeaders headers) {
		super();
		this.headers = headers;
	}

	@Override
	public boolean isReadable(Class<?> type, Type genericType,
			Annotation[] annotations, MediaType mediaType) {
		return type == String.class;
	}

	@Override
	public String readFrom(Class<String> type, Type genericType,
			Annotation[] annotations, MediaType mediaType,
			MultivaluedMap<String, String> httpHeaders, InputStream entityStream)
			throws IOException, WebApplicationException {
		return new HolderClass(headers, info, application, request, provider)
				.toResponse().getEntity().toString();
	}
}
