/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * @(#)R1014ConformanceChecker.java	1.4 03/11/24
 */

/* Copyright (c) 2003 Oracle Corporation.  All rights reserved.  */
package com.sun.ts.tests.jaxws.wsi.w2j.rpc.literal.R1014;

import com.sun.ts.tests.jaxws.common.RequestConformanceChecker;

import javax.xml.ws.handler.soap.SOAPMessageContext;
import javax.xml.soap.*;
import java.util.Iterator;

public class R1014ConformanceChecker extends RequestConformanceChecker{

    public void test(SOAPMessageContext context) throws SOAPException{
        SOAPBody body = getBody(context);
        Iterator children = body.getChildElements();
        SOAPElement element;
        String uri;
        while(children.hasNext() && response == null){
            element = (SOAPElement)children.next();
            uri = element.getElementName().getURI();
            if(uri == null || uri.equals("")){
                response = "failed. Children of soap:Body must be qualified";
            }
        }
    }

    private SOAPBody getBody(SOAPMessageContext context) throws SOAPException{
        return context.getMessage().getSOAPPart().getEnvelope().getBody();
    }
}
