/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id$
 */

package com.sun.ts.tests.jaxws.wsi.w2j.rpc.literal.R11XX;

import com.sun.ts.tests.jaxws.common.HTTPSOAPHandler;
import com.sun.ts.tests.jaxws.common.JAXWS_Util;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.WebServiceException;

import java.util.Map;
import java.util.List;
import java.util.Iterator;

import org.w3c.dom.Element;

import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.soap.SOAPEnvelope;

public class ServerSOAPHandler extends HTTPSOAPHandler{

    private String PASSED = "PASSED";
    private String FAILED = "FAILED";

    protected void processInboundMessage(SOAPMessageContext context) {
       System.out.println("in ServerSOAPHandler:processInboundMessage");
       String result = null;
       try {
          result = verifySoapActionHeader(context);
       } catch (Exception e) {
          throw new RuntimeException("Exception occurred in ServerSOAPHandler:verifySoapActionHeader: "+e);
       }
       if (!result.equals(PASSED)){
             throw new RuntimeException("In ServerSOAPHandler:processInboundMessage: "+result);
       }
   }


    protected String verifySoapActionHeader(SOAPMessageContext context) throws Exception {
         System.out.println("in ServerSOAPHandler:verifySoapActionHeader");
         String result = FAILED;

         JAXWS_Util.dumpHTTPHeaders(context);
         Map<String,List<String>> map1 = (Map<String,List<String>>)context.get(MessageContext.HTTP_REQUEST_HEADERS);
         Map<String,List<String>> map2 = JAXWS_Util.convertKeysToLowerCase(map1);
         List<String> values=map2.get("soapaction");
         if (values != null) {
            System.out.println("SoapAction="+values);
           if (values.contains("\"helloWorld\"") || values.contains("\'helloWorld\'")) {
                result="PASSED";
            } else {
                result="FAILED: the header SOAPAction was not a quoted value:"+values;
            }
         } else {
            result="FAILED: the header SOAPAction was not found";
         }
         return result;
    }


}
