/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: W2JRLR2738Client.java 62602 2011-04-21 14:51:41Z kgrucci $
 */

package com.sun.ts.tests.jaxws.wsi.w2j.rpc.literal.R2738;

import javax.xml.ws.Holder;
import com.sun.ts.tests.jaxws.sharedclients.SOAPClient;
import com.sun.ts.lib.harness.EETest;

public class W2JRLR2738Client extends SOAPClient{

    public W2JRLR2738Client(String webServerHost, int port, int mode) throws EETest.Fault{
        this(webServerHost, port, mode, null);
    }

    public W2JRLR2738Client(String webServerHost, int port, int mode, javax.xml.ws.Service webServiceRef) throws EETest.Fault{
        super(webServerHost, port, mode);
        stubContext.setNamespace("http://w2jrlr2738testservice.org/W2JRLR2738TestService.wsdl");
        stubContext.setService("W2JRLR2738TestService");
        stubContext.setPort("W2JRLR2738TestPort");
        stubContext.setEndpointInterface(W2JRLR2738Test.class);
	stubContext.setWebServiceRef(webServiceRef);
    }

    protected String getEndpointURLProperty() {
        return "wsi.w2jrlr2738.endpoint.1";
    }

    protected String getWSDLURLProperty() {
        return "wsi.w2jrlr2738.wsdlloc.1";
    }

    public String echoIt(String text, 
                         ConfigHeader ch1, 
                         Holder<ConfigHeader> ghh2,
                         Holder<ConfigHeader> ghh3)

                         throws Exception {
        String result="";
        Holder gh = new Holder<String>();
        gh.value=result;
        ((W2JRLR2738Test)stubContext.getStub()).echoIt(text, ch1, ghh2, gh, ghh3);
        return (String)gh.value;
    }

}
