/*
 * Copyright (c) 2009, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: URLClient.java 72229 2013-06-25 18:20:40Z dougd $
 */

package com.sun.ts.tests.jsf.api.javax_faces.el.methodnotfoundexception;

import com.sun.javatest.Status;
import com.sun.ts.tests.jsf.common.client.AbstractUrlClient;

import java.io.PrintWriter;

public final class URLClient extends AbstractUrlClient {

	private static final String CONTEXT_ROOT = "/jsf_el_methnotfoundexc_web";

	public static void main(String[] args) {
		URLClient theTests = new URLClient();
		Status s = theTests.run(args, new PrintWriter(System.out),
				new PrintWriter(System.err));
		s.exit();
	}

	public Status run(String args[], PrintWriter out, PrintWriter err) {
		setContextRoot(CONTEXT_ROOT);
		setServletName(DEFAULT_SERVLET_NAME);
		return super.run(args, out, err);
	}

	/*
	 * @class.setup_props: webServerHost; webServerPort; ts_home;
	 */

	/* Test Declarations */

	/**
	 * @testName: methNotFoundExceptionNoArgCtorTest
	 * @assertion_ids: JSF:JAVADOC:1715
	 * @test_Strategy: Validate no-arg ctor of MethodNotFoundException.
	 */
	public void methNotFoundExceptionNoArgCtorTest() throws Fault {
		TEST_PROPS.setProperty(APITEST, "noArgCtorTest");
		invoke();
	}

	/**
	 * @testName: methNotFoundExceptionMessageArgCtorTest
	 * @assertion_ids: JSF:JAVADOC:1716
	 * @test_Strategy: Validate message ctor of MethodNotFoundException and that
	 *                 getMessage() returns the expected result.
	 */
	public void methNotFoundExceptionMessageArgCtorTest() throws Fault {
		TEST_PROPS.setProperty(APITEST, "messageArgCtorTest");
		invoke();
	}

	/**
	 * @testName: methNotFoundExceptionRootCauseArgCtorTest
	 * @assertion_ids: JSF:JAVADOC:1717
	 * @test_Strategy: Validate the Throwable ctor of MethodNotFoundException
	 *                 and that getCause() returns the expected result.
	 */
	public void methNotFoundExceptionRootCauseArgCtorTest() throws Fault {
		TEST_PROPS.setProperty(APITEST, "rootCauseArgCtorTest");
		invoke();
	}

	/**
	 * @testName: methNotFoundExceptionRootCauseMessageArgsCtorTest
	 * @assertion_ids: JSF:JAVADOC:1718
	 * @test_Strategy: Validate the Throwable and message ctor of
	 *                 MethodNotFoundException and that both getMessage() and
	 *                 getCause() return the expected results.
	 */
	public void methNotFoundExceptionRootCauseMessageArgsCtorTest()
			throws Fault {
		TEST_PROPS.setProperty(APITEST, "rootCauseMessageArgsCtorTest");
		invoke();
	}

} // end of URLClient
