/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id$
 */

package com.sun.ts.tests.jsonb.customizedmapping.instantiation.model;

import javax.json.bind.annotation.JsonbCreator;

public class MultipleFactoryCreatorsContainer {
    private String stringInstance;
    private Integer integerInstance;
    private float floatInstance;

    private MultipleFactoryCreatorsContainer() {}

    @JsonbCreator
    public MultipleFactoryCreatorsContainer createInstance(String stringInstance, Integer integerInstance) {
        MultipleFactoryCreatorsContainer simpleFactoryCreatorContainer = new MultipleFactoryCreatorsContainer();
        simpleFactoryCreatorContainer.setStringInstance(stringInstance);
        simpleFactoryCreatorContainer.setIntegerInstance(integerInstance);
        return simpleFactoryCreatorContainer;
    }

    @JsonbCreator
    public MultipleFactoryCreatorsContainer createInstance(Integer integerInstance, float floatInstance) {
        MultipleFactoryCreatorsContainer simpleFactoryCreatorContainer = new MultipleFactoryCreatorsContainer();
        simpleFactoryCreatorContainer.setIntegerInstance(integerInstance);
        simpleFactoryCreatorContainer.setFloatInstance(floatInstance);
        return simpleFactoryCreatorContainer;
    }

    public String getStringInstance() {
        return stringInstance;
    }

    public void setStringInstance(String stringInstance) {
        this.stringInstance = stringInstance;
    }

    public Integer getIntegerInstance() {
        return integerInstance;
    }

    public void setIntegerInstance(Integer integerInstance) {
        this.integerInstance = integerInstance;
    }

    public float getFloatInstance() {
        return floatInstance;
    }

    public void setFloatInstance(float floatInstance) {
        this.floatInstance = floatInstance;
    }
}
