/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $URL: https://adc4110351.us.oracle.com/svn/spider/branches/cts/8.0/src/com/sun/ts/tests/jstl/common/beans/SimpleBean.java $ $LastChangedDate: 2011-04-15 11:32:31 -0700 (Fri, 15 Apr 2011) $
 */

package com.sun.ts.tests.jstl.common.beans;

/**
 * Simple single-valued bean for testing purposes.
 */
public class SimpleBean {

    /** Creates new NullBean */
    public SimpleBean() {
    }
    
    private String _value = null;

/* 
 * public methods
 * ========================================================================
 */
    
    /**
     * Sets a non-descriptive value
     * @param value some value
     */
    public void setValue(String value) {
        _value = value;
    }
    
    /**
     * Returns the current value of the bean
     * @return the current value 
     */
    public String getValue() {
        return _value;
    }
    
    /**
     * Causes a RuntimeException to be thrown when called.
     */
    public String toString() {
        throw new RuntimeException();
    }
}
