/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id:$
 */
package com.sun.ts.tests.servlet.api.javax_servlet.servletcontext31;

import com.sun.javatest.Status;
import com.sun.ts.tests.servlet.common.client.AbstractUrlClient;
import java.io.PrintWriter;

public class URLClient extends AbstractUrlClient {

    /**
     * Entry point for different-VM execution.  It should delegate to method
     * run(String[], PrintWriter, PrintWriter), and this method should not
     * contain any test configuration.
     */
    public static void main(String[] args) {
        URLClient theTests = new URLClient();
        Status s = theTests.run(args, new PrintWriter(System.out),
                new PrintWriter(System.err));
        s.exit();
    }

    /**
     * Entry point for same-VM execution. In different-VM execution, the
     * main method delegates to this method.
     */
    public Status run(String args[], PrintWriter out, PrintWriter err) {

        setContextRoot("/servlet_js_servletcontext31_web");
        setServletName("TestServlet");

        return super.run(args, out, err);
    }

    /*
     * @class.setup_props: webServerHost;
     *                     webServerPort;
     *                     ts_home;
     *                     logical.hostname.servlet;
     */
    /* Run test */
    /*
     * @testName:  getVirtualServerNameTest
     *
     * @assertion_ids: Servlet:JAVADOC:954;
     *
     * @test_Strategy: 1. Create a Servlet Servlet, define it in web.xml;
     *                 2. verify ServletContext.getVirtualServerName() returns correctly;
     */
    public void getVirtualServerNameTest() throws Fault {
        String expected_virtualservername = _props.getProperty("logical.hostname.servlet").trim();
        TEST_PROPS.setProperty(REQUEST, "GET " + getContextRoot()
                + "/" + getServletName()
                + "?testname=getVirtualServerNameTest&VirtualServerNamePlease="
                + expected_virtualservername + " HTTP/1.0");
        invoke();
    }
}
