/*
 * Copyright (c) 2009, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id:$
 */
package com.sun.ts.tests.servlet.spec.annotationservlet.webservlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@WebServlet(urlPatterns = "/Servlet4URL/*", asyncSupported = true, 
initParams = {@WebInitParam(name = "name1", value = "value1"),
@WebInitParam(name = "name2", value = "value2")},
name = "Servlet4")
public class Servlet4 extends HttpServlet {

    public void service(HttpServletRequest request,
            HttpServletResponse response)
            throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        pw.write("Servlet4_INVOKED");

        pw.print("ServletName=" + getServletName());
        pw.print("isAsyncSupported=" + request.isAsyncSupported());

        pw.write("initParams: ");
        String name = null;
        String value = null;
        Enumeration names = getInitParameterNames();

        while (names.hasMoreElements()) {
            name = (String) names.nextElement();
            value = getInitParameter(name);
            pw.print(name + "=" + value);
        }
    }
}
