/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: TestServlet.java 62571 2011-04-18 20:58:13Z kgrucci $
 */

package com.sun.ts.tests.servlet.spec.rdspecialchar;


import com.sun.ts.tests.servlet.common.servlets.HttpTCKServlet;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;


public class TestServlet extends HttpTCKServlet {


    public void querySemicolonInclude(HttpServletRequest request, HttpServletResponse response)
        throws ServletException, IOException {
        PrintWriter pw = response.getWriter();

        String path = "/include/IncludedServlet?querySemicolonIncludeQuebec;libre";
        RequestDispatcher rd = getServletContext().getRequestDispatcher(path);

        if (rd == null)
            pw.println("Null RequestDispatcher got for path=" + path);
        else
            rd.include(request, response);
    }


    public void querySemicolonForward(HttpServletRequest request, HttpServletResponse response)
        throws ServletException, IOException {
        PrintWriter pw = response.getWriter();

        String path = "/include/IncludedServlet?querySemicolonForwardQuebec;libre";
        RequestDispatcher rd = getServletContext().getRequestDispatcher(path);

        if (rd == null)
            pw.println("Null RequestDispatcher got for path=" + path);
        else
            rd.forward(request, response);
    }

}
