/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id: WSByteBufferPartialClientEndpoint.java 72761 2013-08-30 17:06:49Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.clientendpointonmessage;

import java.io.IOException;
import java.nio.ByteBuffer;

import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.EndpointConfig;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;

import com.sun.ts.tests.websocket.common.client.AnnotatedStringClientEndpoint;
import com.sun.ts.tests.websocket.common.util.IOUtil;

@ClientEndpoint
public class WSByteBufferPartialClientEndpoint extends
		AnnotatedStringClientEndpoint {
	protected Session session;
	private StringBuilder sb = new StringBuilder();

	@OnMessage
	public void echo(ByteBuffer buf, boolean finito) throws IOException {
		sb.append(IOUtil.byteBufferToString(buf)).append("(").append(finito)
				.append(")");
		if (finito) {
			super.onMessage(sb.toString());
			session.getBasicRemote().sendText(
					sb.toString().replaceAll("[(][a-z]*[)]", ""));
			sb = new StringBuilder();
		}
	}

	@OnError
	@Override
	public void onError(Session session, Throwable t) {
		this.session = session;
		super.onError(session, t);
	}

	@OnClose
	@Override
	public void onClose(Session session, CloseReason closeReason) {
		super.onClose(session, closeReason);
	}

	@OnOpen
	@Override
	public void onOpen(Session session, EndpointConfig config) {
		this.session = session;
		super.onOpen(session, config);
	}
}
