/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: AppConfig.java 72712 2013-08-27 10:39:03Z supol $
 */
package com.sun.ts.tests.websocket.ee.javax.websocket.programaticcoder;

import java.util.HashSet;
import java.util.Set;

import javax.websocket.Endpoint;
import javax.websocket.server.ServerApplicationConfig;
import javax.websocket.server.ServerEndpointConfig;

import com.sun.ts.tests.websocket.ee.javax.websocket.coder.WSCLoggerServer;
import com.sun.ts.tests.websocket.ee.javax.websocket.coder.WSCSimpleBinaryEchoServer;
import com.sun.ts.tests.websocket.ee.javax.websocket.coder.WSCSimpleEchoServer;

public class AppConfig implements ServerApplicationConfig {

	@Override
	public Set<ServerEndpointConfig> getEndpointConfigs(
			Set<Class<? extends Endpoint>> endpointClasses) {
		Set<ServerEndpointConfig> set = new HashSet<ServerEndpointConfig>();
		set.add(new BinaryDecoderEndpointConfig());
		set.add(new BinaryEncoderEndpointConfig());
		set.add(new BinaryStreamDecoderEndpointConfig());
		set.add(new BinaryStreamEncoderEndpointConfig());
		set.add(new TextDecoderEndpointConfig());
		set.add(new TextEncoderEndpointConfig());
		set.add(new TextStreamDecoderEndpointConfig());
		set.add(new TextStreamEncoderEndpointConfig());
		set.add(new WillDecodeBinaryDecoderEndpointConfig());
		set.add(new WillDecodeTextDecoderEndpointConfig());
		return set;
	}

	@Override
	public Set<Class<?>> getAnnotatedEndpointClasses(Set<Class<?>> scanned) {
		Set<Class<?>> set = new HashSet<Class<?>>();
		set.add(WSCLoggerServer.class);
		set.add(WSCSimpleBinaryEchoServer.class);
		set.add(WSCSimpleEchoServer.class);
		return set;
	}
}
