/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: WSReaderServer.java 70745 2013-03-15 22:18:24Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.websocketmessage;

import java.io.IOException;

import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;

import com.sun.ts.tests.websocket.common.util.IOUtil;

@ServerEndpoint("/reader")
public class WSReaderServer {

	@OnMessage
	public String reader(java.io.Reader r) throws IOException {
		String msg = IOUtil.readFromReader(r);
		return msg;
	}
	
    @OnError
    public void onError(Session session, Throwable t) throws IOException {
    	System.out.println("@OnError in " + getClass().getName());
    	t.printStackTrace(); //Write to error log, too
    	String message = "Exception: " + IOUtil.printStackTrace(t);
    	session.getBasicRemote().sendText(message);
    }	
}
