/*
 * Copyright (c) 2015, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: OnMessageClientEndpoint.java 74509 2015-05-25 13:33:41Z jsupol $
 */

package com.sun.ts.tests.websocket.negdep.onmessage.client.binarybytebufferint;

import java.nio.ByteBuffer;

import javax.websocket.ClientEndpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;

import com.sun.ts.tests.websocket.common.client.AnnotatedByteBufferClientEndpoint;

@ClientEndpoint
public class OnMessageClientEndpoint extends AnnotatedByteBufferClientEndpoint {

	@OnMessage
	public void onMessage(ByteBuffer msg, int i) {
		clientEndpoint.onMessage(msg);
	}

	@OnError
	public void onError(Session session, Throwable t) {
		clientEndpoint.onError(session, t);
	}

	@OnMessage
	public void onMessage(String msg) {
		clientEndpoint.onMessage(ByteBuffer.wrap(msg.getBytes()));
	}

	@OnOpen
	public void onOpen(Session session, EndpointConfig config) {
		clientEndpoint.onOpen(session, config, false);
	}
}
