/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets;

import java.util.Iterator;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.ArrayType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets.ArraySuperTypeSet;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets.EnumeratedTypeSet;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets.TypeSet;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets.TypeSetEnvironment;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.TTypes;

public class ArrayTypeSet
extends TypeSet {
    protected TypeSet fElemTypeSet;
    private EnumeratedTypeSet fEnumCache = null;

    protected ArrayTypeSet(TypeSetEnvironment typeSetEnvironment) {
        super(typeSetEnvironment);
    }

    public ArrayTypeSet(TypeSet s) {
        super(s.getTypeSetEnvironment());
        this.fElemTypeSet = s;
    }

    public TypeSet getElemTypeSet() {
        return this.fElemTypeSet;
    }

    @Override
    public boolean isUniverse() {
        return false;
    }

    @Override
    public TypeSet makeClone() {
        return new ArrayTypeSet(this.fElemTypeSet);
    }

    @Override
    public boolean isEmpty() {
        return this.fElemTypeSet.isEmpty();
    }

    @Override
    public TypeSet upperBound() {
        return new ArrayTypeSet(this.fElemTypeSet.upperBound());
    }

    @Override
    public TypeSet lowerBound() {
        return new ArrayTypeSet(this.fElemTypeSet.lowerBound());
    }

    @Override
    public boolean hasUniqueLowerBound() {
        return this.fElemTypeSet.hasUniqueLowerBound();
    }

    @Override
    public boolean hasUniqueUpperBound() {
        return this.fElemTypeSet.hasUniqueUpperBound();
    }

    @Override
    public TType uniqueLowerBound() {
        return TTypes.createArrayType(this.fElemTypeSet.uniqueLowerBound(), 1);
    }

    @Override
    public TType uniqueUpperBound() {
        return TTypes.createArrayType(this.fElemTypeSet.uniqueUpperBound(), 1);
    }

    @Override
    public boolean contains(TType t) {
        if (!(t instanceof ArrayType)) {
            return false;
        }
        ArrayType at = (ArrayType)t;
        return this.fElemTypeSet.contains(at.getComponentType());
    }

    @Override
    public boolean containsAll(TypeSet s) {
        if (s instanceof ArrayTypeSet && !(s instanceof ArraySuperTypeSet)) {
            ArrayTypeSet ats = (ArrayTypeSet)s;
            return this.fElemTypeSet.containsAll(ats.fElemTypeSet);
        }
        Iterator<TType> iter = s.iterator();
        while (iter.hasNext()) {
            TType t = iter.next();
            if (this.contains(t)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<TType> iterator() {
        if (this.fEnumCache != null) {
            return this.fEnumCache.iterator();
        }
        return new Iterator<TType>(){
            Iterator<TType> fElemIter;
            {
                this.fElemIter = ArrayTypeSet.this.fElemTypeSet.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.fElemIter.hasNext();
            }

            @Override
            public TType next() {
                return TTypes.createArrayType(this.fElemIter.next(), 1);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public EnumeratedTypeSet enumerate() {
        if (this.fEnumCache == null) {
            this.fEnumCache = new EnumeratedTypeSet(this.getTypeSetEnvironment());
            Iterator<TType> iter = this.fElemTypeSet.iterator();
            while (iter.hasNext()) {
                TType t = iter.next();
                this.fEnumCache.add(TTypes.createArrayType(t, 1));
            }
            this.fEnumCache.initComplete();
        }
        return this.fEnumCache;
    }

    @Override
    public boolean isSingleton() {
        return this.fElemTypeSet.isSingleton();
    }

    @Override
    public TType anyMember() {
        return TTypes.createArrayType(this.fElemTypeSet.anyMember(), 1);
    }

    @Override
    public TypeSet superTypes() {
        return new ArraySuperTypeSet(this.fElemTypeSet);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ArrayTypeSet) {
            ArrayTypeSet other = (ArrayTypeSet)obj;
            return this.fElemTypeSet.equals(other.fElemTypeSet);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.fElemTypeSet.hashCode();
    }

    @Override
    public String toString() {
        return "{" + this.fID + ": array(" + this.fElemTypeSet + ")}";
    }
}

