/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core;

import com.google.common.math.DoubleMath;

public class NumberUtils {
    public static double unsignedConstraintValue(double v, double min, double max) {
        double rv = v;
        if (min >= 0.0) {
            rv = Math.max(rv, min);
        }
        if (max >= 0.0) {
            rv = Math.min(rv, max);
        }
        return rv;
    }

    public static boolean equals(double d1, double d2) {
        return Double.compare(d1, d2) == 0;
    }

    public static boolean notEquals(double d1, double d2) {
        return !NumberUtils.equals(d1, d2);
    }

    public static boolean fuzzyEquals(double d1, double d2) {
        return DoubleMath.fuzzyEquals((double)d1, (double)d2, (double)0.01);
    }

    public static boolean fuzzyNotEquals(double d1, double d2) {
        return !NumberUtils.fuzzyEquals(d1, d2);
    }
}

