/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.resource;

import com.google.inject.Inject;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.resource.persistence.ResourceStorageFacade;
import org.eclipse.xtext.resource.persistence.ResourceStorageLoadable;
import org.eclipse.xtext.resource.persistence.ResourceStorageWritable;
import org.eclipse.xtext.resource.persistence.StorageAwareResource;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.IProjectConfigProvider;
import org.eclipse.xtext.workspace.ISourceFolder;
import org.eclipse.xtext.xbase.resource.BatchLinkableResourceStorageLoadable;
import org.eclipse.xtext.xbase.resource.BatchLinkableResourceStorageWritable;

public class BatchLinkableResourceStorageFacade
extends ResourceStorageFacade {
    @Inject
    private IProjectConfigProvider projectConfigProvider;

    public ResourceStorageLoadable createResourceStorageLoadable(InputStream in) {
        boolean _isStoreNodeModel = this.isStoreNodeModel();
        return new BatchLinkableResourceStorageLoadable(in, _isStoreNodeModel);
    }

    public ResourceStorageWritable createResourceStorageWritable(OutputStream out) {
        boolean _isStoreNodeModel = this.isStoreNodeModel();
        return new BatchLinkableResourceStorageWritable(out, _isStoreNodeModel);
    }

    protected URI getSourceContainerURI(StorageAwareResource resource) {
        URI uri = resource.getURI();
        IProjectConfig mainProject = this.projectConfigProvider.getProjectConfig(resource.getResourceSet());
        if (mainProject != null) {
            ISourceFolder sourceFolder;
            IProjectConfig project = mainProject.getWorkspaceConfig().findProjectContaining(uri);
            ISourceFolder _findSourceFolderContaining = null;
            if (project != null) {
                _findSourceFolderContaining = project.findSourceFolderContaining(uri);
            }
            if ((sourceFolder = _findSourceFolderContaining) != null) {
                return sourceFolder.getPath();
            }
        }
        return super.getSourceContainerURI(resource);
    }
}

