/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.base;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.internal.contexts.Computation;
import org.eclipse.e4.core.internal.contexts.ContextChangeEvent;
import org.eclipse.e4.core.internal.contexts.EclipseContext;
import org.eclipse.e4.core.internal.contexts.WeakGroupedListenerList;
import org.eclipse.fx.core.log.LoggerCreator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.osgi.service.event.Event;

public class Util {
    public static <E> @NonNull Collection<@NonNull E> asCollection(Event event, String propertyName) {
        Object o = event.getProperty(propertyName);
        return o instanceof Collection ? (Set<Object>)o : Collections.singleton(o);
    }

    public static @NonNull String toCSSId(@NonNull String id) {
        return id.replace('.', '-');
    }

    public static IEclipseContext createLocalHandlerContext(@NonNull IEclipseContext parent, @NonNull IEclipseContext activeLeaf, @NonNull String name) {
        IEclipseContext rv = EclipseContextFactory.create((String)name);
        rv.set("efx_handler_context", (Object)activeLeaf);
        return rv;
    }

    public static @Nullable IEclipseContext getActiveHandlerContext(@NonNull IEclipseContext context) {
        return (IEclipseContext)context.get("efx_handler_context");
    }

    public static boolean isLocalHandlerContext(@NonNull IEclipseContext context) {
        return context.get("efx_handler_context") != null;
    }

    public static void setParentContext(@NonNull IEclipseContext target, @NonNull IEclipseContext newParent) {
        target.setParent(newParent);
        EclipseContext c = (EclipseContext)target;
        try {
            Util.invalidateLocalComputations(c, new HashSet());
        }
        catch (Throwable t) {
            LoggerCreator.createLogger(Util.class).error("Failed to invalidate context", t);
        }
    }

    private static void invalidateLocalComputations(EclipseContext c, Set scheduled) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException, InstantiationException, InvocationTargetException {
        Field localValueComputationsField = c.getClass().getDeclaredField("localValueComputations");
        localValueComputationsField.setAccessible(true);
        Map localValueComputations = (Map)localValueComputationsField.get(c);
        Field weakListenersField = c.getClass().getDeclaredField("weakListeners");
        weakListenersField.setAccessible(true);
        WeakGroupedListenerList weakListeners = (WeakGroupedListenerList)weakListenersField.get(c);
        Constructor<?> constructor = ContextChangeEvent.class.getDeclaredConstructors()[0];
        constructor.setAccessible(true);
        ContextChangeEvent event = (ContextChangeEvent)constructor.newInstance(c, 1, null, null, null);
        for (Computation computation : localValueComputations.values()) {
            weakListeners.remove(computation);
            computation.handleInvalid(event, scheduled);
        }
        localValueComputations.clear();
        for (EclipseContext cc : c.getChildren()) {
            Util.invalidateLocalComputations(cc, scheduled);
        }
    }
}

