/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.editors;

import java.util.Map;
import org.eclipse.egerrit.internal.model.ChangeInfo;
import org.eclipse.egerrit.internal.ui.table.model.BranchMatch;
import org.eclipse.egerrit.internal.ui.table.model.BranchSelectionTableModel;
import org.eclipse.egerrit.internal.ui.table.model.ITableModel;
import org.eclipse.egerrit.internal.ui.table.model.ReviewTableSorter;
import org.eclipse.egerrit.internal.ui.table.provider.BranchListLabelProvider;
import org.eclipse.egerrit.internal.ui.utils.Messages;
import org.eclipse.egerrit.internal.ui.utils.UIUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class BranchSelectionDialog
extends Dialog {
    private final int TABLE_STYLE = 68352;
    private TableViewer fViewer;
    private Map<String, BranchMatch> potentialBranches;
    private String selectedBranch = null;
    private Action doubleClickAction;
    private ChangeInfo changeInfo;
    private static final int WIDTH = 400;

    public BranchSelectionDialog(Shell parent, Map<String, BranchMatch> potentialBranches2, ChangeInfo changeInfo) {
        super(parent);
        this.setShellStyle(0x10C70 | BranchSelectionDialog.getDefaultOrientation());
        this.potentialBranches = potentialBranches2;
        this.changeInfo = changeInfo;
    }

    protected Control createDialogArea(Composite parent) {
        this.createTableViewerSection(parent);
        parent.getShell().setText(Messages.BranchSelectionTableModel_title);
        Point minSize = parent.getShell().computeSize(400, -1);
        parent.getShell().setSize(minSize);
        parent.getShell().setMinimumSize(400, minSize.y + 80);
        return super.createDialogArea(parent);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, Messages.BranchSelectionTableModel_new, false);
        this.createButton(parent, 1024, Messages.BranchSelectionTableModel_switch, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.buttonNewPressed();
        } else if (1024 == buttonId) {
            this.buttonSwitchPressed();
        } else if (1 == buttonId) {
            this.cancelPressed();
        }
    }

    protected void buttonNewPressed() {
        this.setReturnCode(0);
        this.close();
    }

    protected void buttonSwitchPressed() {
        this.setReturnCode(1024);
        this.close();
    }

    private TableViewer createTableViewerSection(Composite aParent) {
        GridLayout layout = new GridLayout(2, false);
        aParent.setLayout((Layout)layout);
        Label labelHeader = new Label(aParent, 64);
        labelHeader.setText(NLS.bind((String)Messages.BranchSelectionTableModel_question, (Object)this.changeInfo.getUserSelectedRevision().get_number(), (Object)this.changeInfo.getSubject()));
        labelHeader.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.fViewer = new TableViewer(aParent, 68352);
        this.buildAndLayoutTable();
        ReviewTableSorter.bind(this.fViewer);
        this.fViewer.setComparator((ViewerComparator)new ReviewTableSorter(1));
        this.fViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fViewer.setLabelProvider((IBaseLabelProvider)new BranchListLabelProvider());
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof StructuredSelection) {
                    Map.Entry entry = (Map.Entry)((StructuredSelection)selection).getFirstElement();
                    BranchSelectionDialog.this.selectedBranch = (String)entry.getKey();
                }
            }
        });
        this.fViewer.setInput((Object)this.potentialBranches.entrySet().toArray());
        int foundMatchAt = this.findPerfectMatch();
        if (foundMatchAt >= 0) {
            this.selectPerfectBranch(foundMatchAt);
        }
        return this.fViewer;
    }

    private void buildAndLayoutTable() {
        Table table = this.fViewer.getTable();
        BranchSelectionTableModel[] tableInfo = BranchSelectionTableModel.values();
        int size = tableInfo.length;
        int index = 0;
        while (index < size) {
            this.createTableViewerColumn(tableInfo[index]);
            ++index;
        }
        GridData gribData = new GridData(4, 4, true, true, 2, 2);
        gribData.minimumWidth = tableInfo[0].getWidth();
        Point fontsize = UIUtils.computeFontSize((Composite)table);
        gribData.minimumHeight = fontsize.y * 10;
        this.fViewer.getTable().setLayoutData((Object)gribData);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.makeActions();
        this.hookDoubleClickAction();
    }

    private TableViewerColumn createTableViewerColumn(ITableModel tableInfo) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.fViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(tableInfo.getName());
        column.setWidth(tableInfo.getWidth());
        column.setAlignment(tableInfo.getAlignment());
        column.setResizable(tableInfo.getResize());
        column.setMoveable(tableInfo.getMoveable());
        return viewerColumn;
    }

    private void selectPerfectBranch(int index) {
        this.fViewer.getTable().select(index);
        this.fViewer.getTable().showSelection();
        ISelection selection = this.fViewer.getSelection();
        if (selection instanceof StructuredSelection) {
            Map.Entry entry = (Map.Entry)((StructuredSelection)selection).getFirstElement();
            this.selectedBranch = (String)entry.getKey();
        }
    }

    private int findPerfectMatch() {
        int found = -1;
        TableItem[] tabItems = this.fViewer.getTable().getItems();
        int index = 0;
        while (index < tabItems.length) {
            if (tabItems[index].getText(BranchSelectionTableModel.Match.ordinal()).equals(BranchMatch.PERFECT_MATCH.getValue())) {
                return index;
            }
            ++index;
        }
        return found;
    }

    private void makeActions() {
        this.doubleClickAction = new Action(){

            public void run() {
                BranchSelectionDialog.this.buttonPressed(1024);
            }
        };
    }

    private void hookDoubleClickAction() {
        this.fViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                BranchSelectionDialog.this.doubleClickAction.run();
            }
        });
    }

    public String getSelectedBranch() {
        return this.selectedBranch;
    }
}

