/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.managedbuild.cross.arm.ui.preferences;

import java.util.HashSet;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.embedcdt.core.EclipseUtils;
import org.eclipse.embedcdt.core.ui.LabelFakeFieldEditor;
import org.eclipse.embedcdt.core.ui.XpackDirectoryNotStrictFieldEditor;
import org.eclipse.embedcdt.managedbuild.cross.arm.Activator;
import org.eclipse.embedcdt.managedbuild.cross.arm.ui.Messages;
import org.eclipse.embedcdt.managedbuild.cross.arm.ui.preferences.ToolchainsFieldEditor;
import org.eclipse.embedcdt.managedbuild.cross.preferences.DefaultPreferences;
import org.eclipse.embedcdt.managedbuild.cross.preferences.PersistentPreferences;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class GlobalToolchainsPathsPreferencesPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "org.eclipse.embedcdt.managedbuild.cross.arm.preferencePage.globalToolchainsPaths";
    private PersistentPreferences fPersistentPreferences = Activator.getInstance().getPersistentPreferences();
    private DefaultPreferences fDefaultPreferences = new DefaultPreferences("org.eclipse.embedcdt.managedbuild.cross.arm");

    public GlobalToolchainsPathsPreferencesPage() {
        super(1);
        this.setPreferenceStore((IPreferenceStore)new ScopedPreferenceStore(ConfigurationScope.INSTANCE, "org.eclipse.embedcdt.managedbuild.cross.arm"));
        this.setDescription(Messages.GlobalToolchainsPathsPreferencesPage_description);
    }

    public void init(IWorkbench workbench) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("arm.GlobalToolchainsPathsPreferencesPage.init()");
        }
    }

    protected void createFieldEditors() {
        ToolchainsFieldEditor toolchainNameField = new ToolchainsFieldEditor("toolchain.name", Messages.ToolchainName_label, this.getFieldEditorParent());
        this.addField((FieldEditor)toolchainNameField);
        HashSet<String> toolchainNames = new HashSet<String>();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            IConfiguration[] configs = EclipseUtils.getConfigurationsForProject((IProject)projects[i]);
            if (configs != null) {
                int j = 0;
                while (j < configs.length) {
                    IOption option;
                    IToolChain toolchain = configs[j].getToolChain();
                    if (toolchain != null && (option = toolchain.getOptionBySuperClassId("ilg.gnuarmeclipse.managedbuild.cross.option.toolchain.name")) != null) {
                        try {
                            String name = option.getStringValue();
                            if (!name.isEmpty()) {
                                toolchainNames.add(name);
                            }
                        }
                        catch (BuildException buildException) {}
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (toolchainNames.isEmpty()) {
            toolchainNames.add(this.fPersistentPreferences.getToolchainName());
        }
        for (String toolchainName : toolchainNames) {
            LabelFakeFieldEditor labelField = new LabelFakeFieldEditor(toolchainName, Messages.ToolsPaths_ToolchainName_label, this.getFieldEditorParent());
            this.addField((FieldEditor)labelField);
            boolean isStrict = this.fDefaultPreferences.getBoolean("global.toolchain.path.strict", true);
            String[] xpackNames = this.fDefaultPreferences.getToolchainXpackNames(toolchainName);
            String key = PersistentPreferences.getToolchainKey((String)toolchainName);
            XpackDirectoryNotStrictFieldEditor toolchainPathField = new XpackDirectoryNotStrictFieldEditor(xpackNames, key, Messages.ToolchainPaths_label, this.getFieldEditorParent(), isStrict);
            this.addField((FieldEditor)toolchainPathField);
        }
    }
}

