/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.debug.gdbjtag.datamodel;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.embedcdt.debug.gdbjtag.Activator;
import org.eclipse.embedcdt.debug.gdbjtag.datamodel.SvdDerivedFromPath;
import org.eclipse.embedcdt.debug.gdbjtag.datamodel.SvdEnumeratedValueDMNode;
import org.eclipse.embedcdt.debug.gdbjtag.datamodel.SvdObjectDMNode;
import org.eclipse.embedcdt.packs.core.tree.AbstractTreePreOrderIterator;
import org.eclipse.embedcdt.packs.core.tree.Leaf;
import org.eclipse.embedcdt.packs.core.tree.Node;

public class SvdEnumerationDMNode
extends SvdObjectDMNode {
    private String fUsage = null;
    private SvdEnumeratedValueDMNode fDefaultEnumerationNode = null;

    public SvdEnumerationDMNode(Leaf node) {
        super(node);
        this.getChildren();
    }

    @Override
    public void dispose() {
        this.fUsage = null;
        if (this.fDefaultEnumerationNode != null) {
            this.fDefaultEnumerationNode.dispose();
            this.fDefaultEnumerationNode = null;
        }
        super.dispose();
    }

    @Override
    protected SvdObjectDMNode[] prepareChildren(Leaf node) {
        if (node == null) {
            return null;
        }
        Leaf startNode = this.getDerivedFromNode();
        if (startNode == null) {
            startNode = node;
        }
        if (!startNode.hasChildren()) {
            return null;
        }
        String element = "";
        List children = ((Node)startNode).getChildren();
        if (this.getNode().getPackType() == Leaf.PACK_TYPE_CMSIS) {
            element = "enumeratedValue";
        } else if (this.getNode().getPackType() == Leaf.PACK_TYPE_XPACK) {
            if (!startNode.isType("enumeration")) {
                return null;
            }
            Node valuesNode = (Node)children.get(0);
            if (!valuesNode.isType("values")) {
                return null;
            }
            if (!valuesNode.hasChildren()) {
                return null;
            }
            children = valuesNode.getChildren();
            element = "value";
        }
        LinkedList<SvdEnumeratedValueDMNode> list = new LinkedList<SvdEnumeratedValueDMNode>();
        for (Leaf child : children) {
            if (!child.isType(element)) continue;
            SvdEnumeratedValueDMNode enumeratedValue = new SvdEnumeratedValueDMNode(child);
            String value = enumeratedValue.getValue();
            if (this.getNode().getPackType() == Leaf.PACK_TYPE_CMSIS) {
                if (!value.isEmpty()) {
                    list.add(enumeratedValue);
                    continue;
                }
                if (!enumeratedValue.isDefault()) continue;
                if (this.fDefaultEnumerationNode == null) {
                    this.fDefaultEnumerationNode = enumeratedValue;
                    continue;
                }
                Activator.log((String)("duplicate isDefault enumeratedValue " + enumeratedValue.getName()));
                continue;
            }
            if (this.getNode().getPackType() != Leaf.PACK_TYPE_XPACK) continue;
            if (!value.isEmpty()) {
                list.add(enumeratedValue);
                continue;
            }
            if (!enumeratedValue.isDefault()) continue;
            if (this.fDefaultEnumerationNode == null) {
                this.fDefaultEnumerationNode = enumeratedValue;
                continue;
            }
            Activator.log((String)("duplicate isDefault enumeratedValue " + enumeratedValue.getName()));
        }
        SvdObjectDMNode[] array = list.toArray(new SvdObjectDMNode[list.size()]);
        return array;
    }

    @Override
    protected Leaf findDerivedFromNode() {
        String derivedFromName = this.getNode().getPropertyOrNull("derivedFrom");
        final SvdDerivedFromPath path = SvdDerivedFromPath.createEnumerationPath(derivedFromName);
        if (path == null) {
            return null;
        }
        Node root = this.getNode().getParent();
        while (!root.isType("device")) {
            root = root.getParent();
        }
        AbstractTreePreOrderIterator peripheralNodes = new AbstractTreePreOrderIterator(){

            public boolean isIterable(Leaf node) {
                String clustersElement = "";
                if (node.getPackType() == Node.PACK_TYPE_CMSIS) {
                    clustersElement = "cluster";
                } else if (node.getPackType() == Node.PACK_TYPE_XPACK) {
                    clustersElement = "clusters";
                }
                if (node.isType("peripherals")) {
                    return true;
                }
                if (node.isType("peripheral")) {
                    if (path.peripheralName == null) {
                        return true;
                    }
                    return path.peripheralName.equals(node.getName());
                }
                if (node.isType("registers")) {
                    return true;
                }
                if (node.isType(clustersElement)) {
                    return true;
                }
                if (node.isType("register")) {
                    if (path.registerName == null) {
                        return true;
                    }
                    return path.registerName.equals(node.getName());
                }
                if (node.isType("fields")) {
                    return true;
                }
                if (node.isType("field")) {
                    if (path.fieldName == null) {
                        return true;
                    }
                    return path.fieldName.equals(node.getName());
                }
                if (node.isType("enumeratedValues")) {
                    if (path.enumerationName == null) {
                        return true;
                    }
                    return path.enumerationName.equals(node.getName());
                }
                return false;
            }

            public boolean isLeaf(Leaf node) {
                return node.isType("enumeratedValues");
            }
        };
        peripheralNodes.setTreeNode((Leaf)root);
        Leaf ret = null;
        for (Leaf node : peripheralNodes) {
            if (!node.isType("enumeratedValues")) continue;
            if (ret == null) {
                ret = node;
                continue;
            }
            Activator.log((String)("Non unique SVD path " + path));
        }
        return ret;
    }

    public SvdEnumeratedValueDMNode getDefaultEnumerationNode() {
        return this.fDefaultEnumerationNode;
    }

    public String getUsage() {
        if (this.fUsage == null) {
            this.fUsage = this.getNode().getProperty("usage");
        }
        if (this.fUsage.isEmpty()) {
            this.fUsage = "read-write";
        }
        return this.fUsage;
    }

    public boolean isUsageRead() {
        return "read".equals(this.getUsage()) || "read-write".equals(this.getUsage());
    }

    public boolean isUsageWrite() {
        return "write".equals(this.getUsage()) || "read-write".equals(this.getUsage());
    }

    @Override
    public String toString() {
        if (this.getName().isEmpty()) {
            return "[" + this.getClass().getSimpleName() + ": \"" + this.getDescription() + "\"]";
        }
        return "[" + this.getClass().getSimpleName() + ": " + this.getName() + ", \"" + this.getDescription() + "\"]";
    }
}

