/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.debug.gdbjtag.openocd;

import java.util.regex.Matcher;
import org.eclipse.core.resources.IProject;
import org.eclipse.embedcdt.core.EclipseUtils;

public class DynamicVariableResolver {
    public static final String VARIABLE_EXECUTABLE = "openocd_executable";
    public static final String VARIABLE_PATH = "openocd_path";
    static String[] macros = new String[]{"openocd_executable", "openocd_path"};
    static String[] preferences = new String[]{"executable.name", "install.folder"};
    static String[] defaults = new String[]{"none", "/undefined_path"};

    public static String resolveAll(String input, IProject project) {
        String output = input;
        if (input.indexOf("${") >= 0) {
            int i = 0;
            while (i < macros.length) {
                if (input.indexOf("${" + macros[i] + "}") >= 0) {
                    String tmp = EclipseUtils.getPreferenceValueForId((String)"org.eclipse.embedcdt.debug.gdbjtag.openocd", (String)preferences[i], (String)defaults[i], (IProject)project);
                    tmp = Matcher.quoteReplacement(tmp);
                    output = output.replaceAll("[$][{]" + macros[i] + "[}]", tmp);
                }
                ++i;
            }
        }
        return output;
    }
}

