/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gymnast.runtime.ui.views.parsetree;

import org.eclipse.gymnast.runtime.core.ast.ASTNode;
import org.eclipse.gymnast.runtime.ui.views.parsetree.IParseTreeChangedListener;
import org.eclipse.gymnast.runtime.ui.views.parsetree.IParseTreeViewInput;
import org.eclipse.gymnast.runtime.ui.views.parsetree.ParseTreeLabelProvider;
import org.eclipse.gymnast.runtime.ui.views.parsetree.ParseTreeViewerContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public class ParseTreeView
extends ViewPart
implements ISelectionListener,
IParseTreeChangedListener {
    private TreeViewer _viewer;
    private ParseTreeViewerContentProvider _viewerContentProvider = new ParseTreeViewerContentProvider();
    private ParseTreeLabelProvider _labelProvider = new ParseTreeLabelProvider();
    private IParseTreeViewInput _input;
    private boolean _isDisposed = false;
    private static ParseTreeView _instance;

    public static ParseTreeView getInstance() {
        return _instance;
    }

    public ParseTreeView() {
        if (_instance != null) {
            System.err.println("More than one ParseTreeView!");
        }
        _instance = this;
    }

    public void createPartControl(Composite parent) {
        this._viewer = new TreeViewer(parent);
        this._viewer.setContentProvider((IContentProvider)this._viewerContentProvider);
        this._viewer.setLabelProvider((IBaseLabelProvider)this._labelProvider);
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
        this.getSite().setSelectionProvider((ISelectionProvider)this._viewer);
    }

    public void setFocus() {
    }

    private void changeInput(IParseTreeViewInput newInput) {
        if (this._input == newInput) {
            return;
        }
        if (this._input != null) {
            this._input.removeParseTreeChangedListener(this);
        }
        this._input = newInput;
        if (this._input != null) {
            this._input.addParseTreeChangedListener(this);
        }
        if (this._viewer.getContentProvider() != null) {
            this._viewer.setInput((Object)this._input);
            this._viewer.expandToLevel(2);
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (this._isDisposed) {
            return;
        }
        if (part instanceof IParseTreeViewInput) {
            IParseTreeViewInput newInput = (IParseTreeViewInput)part;
            this.changeInput(newInput);
        } else if (part == this) {
            IStructuredSelection sel;
            Object el;
            if (selection instanceof IStructuredSelection && (el = (sel = (IStructuredSelection)selection).getFirstElement()) != null && el instanceof ASTNode && this._input != null) {
                this._input.selectNode((ASTNode)el);
            }
        } else {
            this.changeInput(null);
        }
    }

    @Override
    public void parseTreeChanged(final ASTNode[] changedNodes) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (changedNodes == null || changedNodes.length == 0) {
                    if (!ParseTreeView.this._viewer.getControl().isDisposed()) {
                        ParseTreeView.this._viewer.refresh();
                    }
                } else {
                    int i = 0;
                    while (i < changedNodes.length) {
                        ASTNode n = changedNodes[i];
                        ParseTreeView.this._viewer.refresh((Object)n);
                        ++i;
                    }
                }
            }
        });
    }

    public void selectNode(ASTNode node) {
        if (node == null) {
            this._viewer.setSelection(null);
            return;
        }
        this._viewer.setSelection((ISelection)new StructuredSelection((Object)node), true);
        if (this._input != null) {
            this._input.selectNode(node);
        }
    }

    public void dispose() {
        if (this._input != null) {
            this._input.removeParseTreeChangedListener(this);
        }
        _instance = null;
        this._isDisposed = true;
        super.dispose();
    }
}

