/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.runtime.distributions;

import org.eclipse.escet.cif.simulator.runtime.CifSimulatorException;
import org.eclipse.escet.cif.simulator.runtime.CifSimulatorMath;
import org.eclipse.escet.cif.simulator.runtime.distributions.CifRandomGenerator;
import org.eclipse.escet.cif.simulator.runtime.distributions.GammaDistribution;
import org.eclipse.escet.cif.simulator.runtime.distributions.RealDistribution;
import org.eclipse.escet.common.java.Strings;

public class BetaDistribution
extends RealDistribution {
    private final CifRandomGenerator randGen;
    private final double a;
    private final double b;

    public BetaDistribution(CifRandomGenerator randGen, double a, double b) {
        this.randGen = randGen;
        this.a = a;
        this.b = b;
        if (a <= 0.0) {
            String msg1 = Strings.fmt((String)"Invalid operation: %s.", (Object[])new Object[]{this});
            String msg2 = "The first shape parameter is not positive.";
            CifSimulatorException e = new CifSimulatorException(msg2);
            throw new CifSimulatorException(msg1, e);
        }
        if (b <= 0.0) {
            String msg1 = Strings.fmt((String)"Invalid operation: %s.", (Object[])new Object[]{this});
            String msg2 = "The second shape parameter is not positive.";
            CifSimulatorException e = new CifSimulatorException(msg2);
            throw new CifSimulatorException(msg1, e);
        }
    }

    private BetaDistribution(BetaDistribution distribution) {
        this.randGen = distribution.randGen.copy();
        this.a = distribution.a;
        this.b = distribution.b;
    }

    @Override
    public RealDistribution copy() {
        return new BetaDistribution(this);
    }

    @Override
    public double sample() {
        double g1 = GammaDistribution.sample(this.randGen, this.a, 1.0);
        double g2 = GammaDistribution.sample(this.randGen, this.b, 1.0);
        return g1 / (g1 + g2);
    }

    @Override
    public String toString() {
        return Strings.fmt((String)"beta(%s, %s)", (Object[])new Object[]{CifSimulatorMath.realToStr(this.a), CifSimulatorMath.realToStr(this.b)});
    }
}

