/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.setext.texteditorbase.rules;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class LiteralsRule
implements IRule {
    private final int[][] literals;
    private final IToken token;
    private final int[] buffer;
    private int bufCount;

    public LiteralsRule(String[] literals, IToken token) {
        int[][] lits = new int[literals.length][];
        int maxLength = 0;
        int i = 0;
        while (i < lits.length) {
            String literal = literals[i];
            Assert.check((literal.length() > 0 ? 1 : 0) != 0);
            lits[i] = Strings.getCodePoints((String)literal);
            if (literal.length() > maxLength) {
                maxLength = literal.length();
            }
            ++i;
        }
        Arrays.sort(lits, new Comparator<int[]>(){

            @Override
            public int compare(int[] o1, int[] o2) {
                return Integer.valueOf(o1.length).compareTo(o2.length);
            }
        });
        this.literals = lits;
        this.token = token;
        this.buffer = new int[maxLength];
        this.bufCount = 0;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        this.bufCount = 0;
        int[][] nArray = this.literals;
        int n = this.literals.length;
        int n2 = 0;
        while (n2 < n) {
            int[] literal = nArray[n2];
            if (this.matchesLiteral(scanner, literal)) {
                return this.token;
            }
            ++n2;
        }
        this.unreadBuffer(scanner);
        return Token.UNDEFINED;
    }

    private boolean matchesLiteral(ICharacterScanner scanner, int[] literal) {
        int i = 0;
        while (i < literal.length) {
            int codePoint = this.getCodePoint(scanner, i);
            if (codePoint == -1) {
                return false;
            }
            if (codePoint != literal[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private int getCodePoint(ICharacterScanner scanner, int idx) {
        if (idx < this.bufCount) {
            return this.buffer[idx];
        }
        if (idx == this.bufCount) {
            int codePoint;
            this.buffer[idx] = codePoint = scanner.read();
            ++this.bufCount;
            return codePoint;
        }
        throw new IndexOutOfBoundsException("idx > bufCount");
    }

    private void unreadBuffer(ICharacterScanner scanner) {
        int i = 0;
        while (i < this.bufCount) {
            scanner.unread();
            ++i;
        }
    }
}

