/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.management;

import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.eclipse.gemini.management.configurationadmin.ConfigAdminManager;
import org.eclipse.gemini.management.framework.BundleState;
import org.eclipse.gemini.management.framework.BundleWiringState;
import org.eclipse.gemini.management.framework.CustomServiceStateMBean;
import org.eclipse.gemini.management.framework.Framework;
import org.eclipse.gemini.management.framework.PackageState;
import org.eclipse.gemini.management.framework.ServiceState;
import org.eclipse.gemini.management.permissionadmin.PermissionManager;
import org.eclipse.gemini.management.provisioning.Provisioning;
import org.eclipse.gemini.management.useradmin.UserManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.jmx.framework.BundleStateMBean;
import org.osgi.jmx.framework.FrameworkMBean;
import org.osgi.jmx.framework.PackageStateMBean;
import org.osgi.jmx.framework.wiring.BundleWiringStateMBean;
import org.osgi.jmx.service.cm.ConfigurationAdminMBean;
import org.osgi.jmx.service.permissionadmin.PermissionAdminMBean;
import org.osgi.jmx.service.provisioning.ProvisioningServiceMBean;
import org.osgi.jmx.service.useradmin.UserAdminMBean;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.log.LogService;
import org.osgi.service.permissionadmin.PermissionAdmin;
import org.osgi.service.provisioning.ProvisioningService;
import org.osgi.service.useradmin.UserAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Activator
implements BundleActivator {
    private static final String REGION_KEY = "region";
    private static final String FRAMEWORK_KEY = "framework";
    private static final String UUID_KEY = "uuid";
    private static final String REGION_SUPPORT = "org.eclipse.gemini.management.region.support";
    private final List<MBeanServer> mbeanServers = new CopyOnWriteArrayList<MBeanServer>();
    private final Object myLock = new Object();
    private final AtomicBoolean shuttingdown = new AtomicBoolean(false);
    private String uuid_value;
    private ObjectName frameworkName;
    private ObjectName bundleStateName;
    private ObjectName bundleWiringStateName;
    private ObjectName packageStateName;
    private ObjectName serviceStateName;
    private ObjectName configAdminName;
    private ObjectName permissionAdminName;
    private ObjectName provisioningServiceName;
    private ObjectName userAdminName;
    private ServiceTracker<MBeanServer, ?> mbeanServiceTracker;
    private BundleContext bundleContext = null;
    private StandardMBean framework;
    private StandardMBean bundleState;
    private StandardMBean bundleWiringState;
    private StandardMBean packageState;
    private StandardMBean serviceState;
    private ServiceTracker<ConfigurationAdmin, ?> configAdminTracker;
    private ServiceTracker<PermissionAdmin, ?> permissionAdminTracker;
    private ServiceTracker<ProvisioningService, ?> provisioningServiceTracker;
    private ServiceTracker<UserAdmin, ?> userAdminTracker;
    private ServiceTracker<LogService, ?> logServiceTracker;
    private String regionName;
    private LogService logger;

    private void log(int level, String message) {
        if (this.logger != null) {
            this.logger.log(level, message);
        }
    }

    private void log(int level, String message, Throwable t) {
        if (this.logger != null) {
            this.logger.log(level, message, t);
        }
    }

    public void start(BundleContext bundleContext) throws Exception {
        this.bundleContext = bundleContext;
        this.logServiceTracker = new ServiceTracker(bundleContext, LogService.class, (ServiceTrackerCustomizer)new LogServiceTracker());
        this.logServiceTracker.open();
        this.uuid_value = this.bundleContext.getBundle(0L).getBundleContext().getProperty("org.osgi.framework.uuid");
        String regionSupportProperty = bundleContext.getProperty(REGION_SUPPORT);
        if (regionSupportProperty != null && Boolean.valueOf(regionSupportProperty).booleanValue()) {
            ServiceReference service = bundleContext.getServiceReference("org.eclipse.equinox.region.Region");
            Object regionService = bundleContext.getService(service);
            this.regionName = (String)regionService.getClass().getDeclaredMethod("getRegion", Bundle.class).invoke(regionService, bundleContext.getBundle());
        } else {
            this.regionName = null;
        }
        this.createObjectNames();
        this.createMBeansAndTrackers();
        this.registerDefaultMBeanServer();
        this.mbeanServiceTracker = new ServiceTracker(this.bundleContext, MBeanServer.class, (ServiceTrackerCustomizer)new MBeanServiceTracker());
        this.log(3, "Awaiting initial MBeanServer service registration");
        this.mbeanServiceTracker.open();
    }

    private void createObjectNames() {
        try {
            this.frameworkName = this.translateObjectName("osgi.core:type=framework,version=1.7", true);
            this.bundleStateName = this.translateObjectName("osgi.core:type=bundleState,version=1.7", true);
            this.bundleWiringStateName = this.translateObjectName("osgi.core:type=wiringState,version=1.1", true);
            this.serviceStateName = this.translateObjectName("osgi.core:type=serviceState,version=1.7", true);
            this.packageStateName = this.translateObjectName("osgi.core:type=packageState,version=1.5", false);
            this.configAdminName = this.translateObjectName("osgi.compendium:service=cm,version=1.3", false);
            this.permissionAdminName = this.translateObjectName("osgi.core:service=permissionadmin,version=1.2", false);
            this.provisioningServiceName = this.translateObjectName("osgi.compendium:service=provisioning,version=1.2", false);
            this.userAdminName = this.translateObjectName("osgi.compendium:service=useradmin,version=1.1", false);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to start Gemini Management, Object name creation failed.", e);
        }
    }

    private ObjectName translateObjectName(String objectName, boolean addFrameworkAndUUID) throws MalformedObjectNameException {
        StringBuilder builder = new StringBuilder(objectName);
        if (addFrameworkAndUUID) {
            builder.append(",framework=" + this.bundleContext.getBundle(0L).getSymbolicName());
            builder.append(",uuid=" + this.uuid_value);
        }
        if (this.regionName != null) {
            builder.append(",region=" + this.regionName);
        }
        return new ObjectName(builder.toString());
    }

    private void registerDefaultMBeanServer() {
        if ("false".equals(this.bundleContext.getProperty("register.default.mbeanserver"))) {
            return;
        }
        ServiceReference ref = this.bundleContext.getServiceReference(MBeanServer.class);
        if (ref == null) {
            this.bundleContext.registerService(MBeanServer.class.getCanonicalName(), (Object)ManagementFactory.getPlatformMBeanServer(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext arg0) throws Exception {
        this.shuttingdown.set(true);
        this.mbeanServiceTracker.close();
        Object object = this.myLock;
        synchronized (object) {
            this.userAdminTracker.close();
            this.provisioningServiceTracker.close();
            this.permissionAdminTracker.close();
            this.configAdminTracker.close();
            for (MBeanServer mbeanServer : this.mbeanServers) {
                this.deregisterServices(mbeanServer);
            }
            this.framework = null;
            this.bundleState = null;
            this.bundleWiringState = null;
            this.serviceState = null;
            this.packageState = null;
            this.configAdminTracker = null;
            this.permissionAdminTracker = null;
            this.provisioningServiceTracker = null;
            this.userAdminTracker = null;
        }
        this.mbeanServers.clear();
        this.logServiceTracker.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deregisterServices(MBeanServer mbeanServer) {
        Object object = this.myLock;
        synchronized (object) {
            this.deregisterService(mbeanServer, this.frameworkName);
            this.deregisterService(mbeanServer, this.bundleStateName);
            this.deregisterService(mbeanServer, this.bundleWiringStateName);
            this.deregisterService(mbeanServer, this.serviceStateName);
            this.deregisterService(mbeanServer, this.packageStateName);
            this.deregisterService(mbeanServer, this.configAdminName);
            this.deregisterService(mbeanServer, this.permissionAdminName);
            this.deregisterService(mbeanServer, this.provisioningServiceName);
            this.deregisterService(mbeanServer, this.userAdminName);
        }
    }

    private void deregisterService(MBeanServer mBeanServer, ObjectName objectName) {
        this.log(3, "Deregistering bundle wiring state with MBeanServer: " + mBeanServer);
        try {
            if (mBeanServer.isRegistered(objectName)) {
                mBeanServer.unregisterMBean(objectName);
            }
        }
        catch (InstanceNotFoundException e) {
            this.log(4, String.valueOf(objectName.getCanonicalName()) + " not found on deregistration", e);
        }
        catch (MBeanRegistrationException e) {
            this.log(3, String.valueOf(objectName.getCanonicalName()) + " deregistration problem", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerServices(MBeanServer mbeanServer) {
        if (this.shuttingdown.get()) {
            return;
        }
        Object object = this.myLock;
        synchronized (object) {
            this.registerMBean(mbeanServer, this.frameworkName, this.framework);
            this.registerMBean(mbeanServer, this.bundleStateName, this.bundleState);
            this.registerMBean(mbeanServer, this.bundleWiringStateName, this.bundleWiringState);
            this.registerMBean(mbeanServer, this.serviceStateName, this.serviceState);
            this.registerMBean(mbeanServer, this.packageStateName, this.packageState);
        }
    }

    private void registerMBean(MBeanServer mbeanServer, ObjectName objectName, Object service) {
        if (this.shuttingdown.get()) {
            return;
        }
        this.log(3, "Registering '" + objectName.getCanonicalName() + "' with MBeanServer: " + mbeanServer);
        try {
            mbeanServer.registerMBean(service, objectName);
        }
        catch (InstanceAlreadyExistsException e) {
            this.log(3, "Cannot register " + objectName, e);
        }
        catch (MBeanRegistrationException e) {
            this.log(1, "Cannot register " + objectName, e);
        }
        catch (NotCompliantMBeanException e) {
            this.log(1, "Cannot register " + objectName, e);
        }
    }

    private void createMBeansAndTrackers() {
        try {
            this.framework = new StandardMBean(new Framework(this.bundleContext), FrameworkMBean.class);
        }
        catch (NotCompliantMBeanException e) {
            this.log(1, "Unable to create StandardMBean for Framework", e);
            return;
        }
        try {
            this.bundleState = new StandardMBean(new BundleState(this.bundleContext), BundleStateMBean.class);
        }
        catch (NotCompliantMBeanException e) {
            this.log(1, "Unable to create StandardMBean for BundleState", e);
            return;
        }
        try {
            this.bundleWiringState = new StandardMBean(new BundleWiringState(this.bundleContext), BundleWiringStateMBean.class);
        }
        catch (NotCompliantMBeanException e) {
            this.log(1, "Unable to create StandardMBean for BundleWiringState", e);
            return;
        }
        try {
            this.serviceState = new StandardMBean(new ServiceState(this.bundleContext), CustomServiceStateMBean.class);
        }
        catch (NotCompliantMBeanException e) {
            this.log(1, "Unable to create StandardMBean for ServiceState", e);
            return;
        }
        try {
            this.packageState = new StandardMBean(new PackageState(this.bundleContext), PackageStateMBean.class);
        }
        catch (NotCompliantMBeanException e) {
            this.log(1, "Unable to create StandardMBean for PackageState", e);
            return;
        }
        this.configAdminTracker = new ServiceTracker(this.bundleContext, "org.osgi.service.cm.ConfigurationAdmin", (ServiceTrackerCustomizer)new ConfigAdminTracker());
        this.permissionAdminTracker = new ServiceTracker(this.bundleContext, "org.osgi.service.permissionadmin.PermissionAdmin", (ServiceTrackerCustomizer)new PermissionAdminTracker());
        this.provisioningServiceTracker = new ServiceTracker(this.bundleContext, "org.osgi.service.provisioning.ProvisioningService", (ServiceTrackerCustomizer)new ProvisioningServiceTracker());
        this.userAdminTracker = new ServiceTracker(this.bundleContext, "org.osgi.service.useradmin.UserAdmin", (ServiceTrackerCustomizer)new UserAdminTracker());
        this.configAdminTracker.open();
        this.permissionAdminTracker.open();
        this.provisioningServiceTracker.open();
        this.userAdminTracker.open();
    }

    private class ConfigAdminTracker
    implements ServiceTrackerCustomizer<ConfigurationAdmin, Object> {
        private StandardMBean manager;

        private ConfigAdminTracker() {
        }

        public Object addingService(ServiceReference<ConfigurationAdmin> reference) {
            ConfigurationAdmin admin;
            try {
                admin = (ConfigurationAdmin)Activator.this.bundleContext.getService(reference);
            }
            catch (ClassCastException e) {
                Activator.this.log(1, "Incompatible class version for the Configuration Admin Manager", e);
                return Activator.this.bundleContext.getService(reference);
            }
            try {
                this.manager = new StandardMBean(new ConfigAdminManager(admin, Activator.this.logger), ConfigurationAdminMBean.class);
            }
            catch (NotCompliantMBeanException e) {
                Activator.this.log(1, "Unable to create Configuration Admin Manager", e);
                return admin;
            }
            for (MBeanServer mbeanServer : Activator.this.mbeanServers) {
                Activator.this.registerMBean(mbeanServer, Activator.this.configAdminName, this.manager);
            }
            return admin;
        }

        public void modifiedService(ServiceReference<ConfigurationAdmin> reference, Object service) {
        }

        public void removedService(ServiceReference<ConfigurationAdmin> reference, Object service) {
            for (MBeanServer mbeanServer : Activator.this.mbeanServers) {
                Activator.this.log(3, "deregistering configuration admin from: " + mbeanServer + " with name: " + Activator.this.configAdminName);
                try {
                    mbeanServer.unregisterMBean(Activator.this.configAdminName);
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    Activator.this.log(3, "Configuration Manager MBean was never registered");
                }
                catch (MBeanRegistrationException e) {
                    Activator.this.log(3, "Cannot deregister Configuration Manager MBean", e);
                }
            }
        }
    }

    private class LogServiceTracker
    implements ServiceTrackerCustomizer<LogService, Object> {
        private LogServiceTracker() {
        }

        public Object addingService(ServiceReference<LogService> reference) {
            Activator.this.logger = (LogService)Activator.this.bundleContext.getService(reference);
            return Activator.this.logger;
        }

        public void modifiedService(ServiceReference<LogService> reference, Object service) {
        }

        public void removedService(ServiceReference<LogService> reference, Object service) {
            Activator.this.logger = null;
        }
    }

    private class MBeanServiceTracker
    implements ServiceTrackerCustomizer<MBeanServer, Object> {
        private MBeanServiceTracker() {
        }

        public MBeanServer addingService(ServiceReference<MBeanServer> servicereference) {
            try {
                Activator.this.log(3, "Adding MBeanServer: " + servicereference);
                final MBeanServer mbeanServer = (MBeanServer)Activator.this.bundleContext.getService(servicereference);
                Activator.this.mbeanServers.add(mbeanServer);
                Runnable registration = new Runnable(){

                    @Override
                    public void run() {
                        Activator.this.registerServices(mbeanServer);
                    }
                };
                Thread registrationThread = new Thread(registration, "JMX Core MBean Registration");
                registrationThread.setDaemon(true);
                registrationThread.start();
                return mbeanServer;
            }
            catch (RuntimeException e) {
                Activator.this.log(1, "uncaught exception in addingService", e);
                throw e;
            }
        }

        public void modifiedService(ServiceReference<MBeanServer> servicereference, Object obj) {
        }

        public void removedService(ServiceReference<MBeanServer> servicereference, Object obj) {
            try {
                Activator.this.log(3, "Removing MBeanServer: " + servicereference);
                final MBeanServer mbeanServer = (MBeanServer)Activator.this.bundleContext.getService(servicereference);
                Activator.this.mbeanServers.remove(mbeanServer);
                Runnable deregister = new Runnable(){

                    @Override
                    public void run() {
                        Activator.this.deregisterServices(mbeanServer);
                    }
                };
                Thread deregisterThread = new Thread(deregister, "JMX Core MBean Deregistration");
                deregisterThread.setDaemon(true);
                deregisterThread.start();
            }
            catch (Throwable e) {
                Activator.this.log(3, "uncaught exception in removedService", e);
            }
        }
    }

    private class PermissionAdminTracker
    implements ServiceTrackerCustomizer<PermissionAdmin, Object> {
        private StandardMBean manager;

        private PermissionAdminTracker() {
        }

        public Object addingService(ServiceReference<PermissionAdmin> reference) {
            PermissionAdmin admin;
            try {
                admin = (PermissionAdmin)Activator.this.bundleContext.getService(reference);
            }
            catch (ClassCastException e) {
                Activator.this.log(1, "Incompatible class version for the Permission Admin Manager", e);
                return Activator.this.bundleContext.getService(reference);
            }
            try {
                this.manager = new StandardMBean(new PermissionManager(admin), PermissionAdminMBean.class);
            }
            catch (NotCompliantMBeanException e) {
                Activator.this.log(1, "Unable to create Permission Admin Manager", e);
                return admin;
            }
            for (MBeanServer mbeanServer : Activator.this.mbeanServers) {
                Activator.this.log(3, "Registering permission admin with MBeanServer: " + mbeanServer + " with name: " + Activator.this.permissionAdminName);
                try {
                    mbeanServer.registerMBean(this.manager, Activator.this.permissionAdminName);
                }
                catch (InstanceAlreadyExistsException e) {
                    Activator.this.log(3, "Cannot register Permission Manager MBean", e);
                }
                catch (MBeanRegistrationException e) {
                    Activator.this.log(1, "Cannot register Permission Manager MBean", e);
                }
                catch (NotCompliantMBeanException e) {
                    Activator.this.log(1, "Cannot register Permission Manager MBean", e);
                }
            }
            return admin;
        }

        public void modifiedService(ServiceReference<PermissionAdmin> reference, Object service) {
        }

        public void removedService(ServiceReference<PermissionAdmin> reference, Object service) {
            for (MBeanServer mbeanServer : Activator.this.mbeanServers) {
                Activator.this.log(3, "deregistering permission admin with MBeanServer: " + mbeanServer + " with name: " + Activator.this.permissionAdminName);
                try {
                    mbeanServer.unregisterMBean(Activator.this.permissionAdminName);
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    Activator.this.log(3, "Permission Manager MBean was never registered");
                }
                catch (MBeanRegistrationException e) {
                    Activator.this.log(1, "Cannot deregister Permission Manager MBean", e);
                }
            }
        }
    }

    private class ProvisioningServiceTracker
    implements ServiceTrackerCustomizer<ProvisioningService, Object> {
        private StandardMBean provisioning;

        private ProvisioningServiceTracker() {
        }

        public Object addingService(ServiceReference<ProvisioningService> reference) {
            ProvisioningService service;
            try {
                service = (ProvisioningService)Activator.this.bundleContext.getService(reference);
            }
            catch (ClassCastException e) {
                Activator.this.log(1, "Incompatible class version for the Provisioning service", e);
                return Activator.this.bundleContext.getService(reference);
            }
            try {
                this.provisioning = new StandardMBean(new Provisioning(service), ProvisioningServiceMBean.class);
            }
            catch (NotCompliantMBeanException e) {
                Activator.this.log(1, "Unable to create Provisioning Service Manager", e);
                return service;
            }
            for (MBeanServer mbeanServer : Activator.this.mbeanServers) {
                Activator.this.log(3, "Registering provisioning service with MBeanServer: " + mbeanServer + " with name: " + Activator.this.provisioningServiceName);
                try {
                    mbeanServer.registerMBean(this.provisioning, Activator.this.provisioningServiceName);
                }
                catch (InstanceAlreadyExistsException e) {
                    Activator.this.log(3, "Cannot register Provisioning Service MBean", e);
                }
                catch (MBeanRegistrationException e) {
                    Activator.this.log(1, "Cannot register Provisioning Service MBean", e);
                }
                catch (NotCompliantMBeanException e) {
                    Activator.this.log(1, "Cannot register Provisioning Service MBean", e);
                }
            }
            return service;
        }

        public void modifiedService(ServiceReference<ProvisioningService> reference, Object service) {
        }

        public void removedService(ServiceReference<ProvisioningService> reference, Object service) {
            for (MBeanServer mbeanServer : Activator.this.mbeanServers) {
                Activator.this.log(3, "deregistering provisioning service with MBeanServer: " + mbeanServer + " with name: " + Activator.this.provisioningServiceName);
                try {
                    mbeanServer.unregisterMBean(Activator.this.provisioningServiceName);
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    Activator.this.log(3, "Provisioning Service MBean was never registered");
                }
                catch (MBeanRegistrationException e) {
                    Activator.this.log(1, "Cannot deregister Provisioning Service MBean", e);
                }
            }
        }
    }

    private class UserAdminTracker
    implements ServiceTrackerCustomizer<UserAdmin, Object> {
        private StandardMBean manager;

        private UserAdminTracker() {
        }

        public Object addingService(ServiceReference<UserAdmin> reference) {
            UserAdmin admin;
            try {
                admin = (UserAdmin)Activator.this.bundleContext.getService(reference);
            }
            catch (ClassCastException e) {
                Activator.this.log(1, "Incompatible class version for the User Admin manager", e);
                return Activator.this.bundleContext.getService(reference);
            }
            try {
                this.manager = new StandardMBean(new UserManager(admin), UserAdminMBean.class);
            }
            catch (NotCompliantMBeanException notCompliantMBeanException) {
                Activator.this.log(1, "Unable to create User Admin Manager");
                return admin;
            }
            for (MBeanServer mbeanServer : Activator.this.mbeanServers) {
                Activator.this.log(3, "Registering user admin with MBeanServer: " + mbeanServer + " with name: " + Activator.this.userAdminName);
                try {
                    mbeanServer.registerMBean(this.manager, Activator.this.userAdminName);
                }
                catch (InstanceAlreadyExistsException e) {
                    Activator.this.log(3, "Cannot register User Manager MBean", e);
                }
                catch (MBeanRegistrationException e) {
                    Activator.this.log(1, "Cannot register User Manager MBean", e);
                }
                catch (NotCompliantMBeanException e) {
                    Activator.this.log(1, "Cannot register User Manager MBean", e);
                }
            }
            return admin;
        }

        public void modifiedService(ServiceReference<UserAdmin> reference, Object service) {
        }

        public void removedService(ServiceReference<UserAdmin> reference, Object service) {
            for (MBeanServer mbeanServer : Activator.this.mbeanServers) {
                Activator.this.log(3, "Deregistering user admin with MBeanServer: " + mbeanServer + " with name: " + Activator.this.userAdminName);
                try {
                    mbeanServer.unregisterMBean(Activator.this.userAdminName);
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    Activator.this.log(3, "User Manager MBean was never registered");
                }
                catch (MBeanRegistrationException e) {
                    Activator.this.log(1, "Cannot deregister User Manager MBean", e);
                }
            }
        }
    }
}

