/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.extender;

import org.eclipse.gemini.web.core.WebContainer;
import org.eclipse.gemini.web.extender.WebContainerBundleCustomizer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public final class ExtenderActivator
implements BundleActivator {
    private ServiceTracker<WebContainer, String> serviceTracker;

    public void start(BundleContext context) {
        this.serviceTracker = new ServiceTracker(context, WebContainer.class, (ServiceTrackerCustomizer)new ExtendedWebContainerTracker(context));
        this.serviceTracker.open();
    }

    public void stop(BundleContext context) {
        this.serviceTracker.close();
    }

    private static final class ExtendedWebContainerTracker
    implements ServiceTrackerCustomizer<WebContainer, String> {
        private final BundleContext context;
        private BundleTracker<Object> bundleTracker;

        public ExtendedWebContainerTracker(BundleContext context) {
            this.context = context;
        }

        public String addingService(ServiceReference<WebContainer> reference) {
            if (this.bundleTracker == null) {
                Bundle systemBundle = this.context.getBundle(0L);
                this.bundleTracker = new BundleTracker(systemBundle.getBundleContext(), 32, (BundleTrackerCustomizer)new WebContainerBundleCustomizer((WebContainer)this.context.getService(reference), this.context.getBundle()));
            }
            this.bundleTracker.open();
            return reference.getBundle().getSymbolicName();
        }

        public void modifiedService(ServiceReference<WebContainer> reference, String service) {
        }

        public void removedService(ServiceReference<WebContainer> reference, String service) {
            this.bundleTracker.close();
            this.bundleTracker = null;
        }
    }
}

