/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.wizard.batch;

import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.gendoc.GendocProcess;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.IGendocDiagnostician;
import org.eclipse.gendoc.services.IProgressMonitorService;
import org.eclipse.gendoc.tags.handlers.IConfigurationService;
import org.eclipse.gendoc.wizard.Activator;
import org.eclipse.gendoc.wizard.IGendocRunner;
import org.eclipse.gendoc.wizard.IGendocTemplate;
import org.eclipse.gendoc.wizard.Utils;
import org.eclipse.gendoc.wizard.batch.ArgOpt;
import org.eclipse.gendoc.wizard.batch.GetOpt;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.statushandlers.AbstractStatusHandler;

public class GendocWizardBatchModeApplication
implements IApplication {
    private static final String RUNNERS_LIST = "runners_list";
    private static final String OUTPUT = "output";
    private static final String MODEL = "model";
    private static final String RUNNER_CLASS = "runner_class";
    private boolean validArguments = true;
    private ArgOpt runnerClassArg = new ArgOpt("runner_class", 0, 1, "rc", "runner class ");
    private ArgOpt modelArg = new ArgOpt("model", 0, 1, "mdl", "UML model ");
    private ArgOpt outputArg = new ArgOpt("output", 0, 1, "out", "output file complete path ");
    private ArgOpt allRunnersArg = new ArgOpt("runners_list", 1, 2, "rl", "list all runners ");
    private String argRunnerClass = "";
    private String argModel = "";
    private String argOutput = "";

    public Object start(IApplicationContext context) throws Exception {
        Display.getDefault().wake();
        this.setupWorkbench();
        String[] args = (String[])context.getArguments().get("application.args");
        GetOpt getOpt = new GetOpt();
        String argFlat = getOpt.getFlatArguments(args);
        if (argFlat.indexOf("--runners_list") >= 0 || argFlat.indexOf("-rl") >= 0) {
            System.out.println("Available runners :");
            for (IGendocRunner lPlatformRunner : Utils.getAllRunners()) {
                System.out.println(String.format("\t- %s ", lPlatformRunner.getClass().getName()));
                Map<String, String> lAddParams = lPlatformRunner.getAdditionnalParameters();
                if (lAddParams == null || lAddParams.isEmpty()) continue;
                System.out.println("\t\t-> Additional parameters: ");
                for (String lAddParam : lAddParams.keySet()) {
                    System.out.println(String.format("\t\t\t* name: %s; description: %s ", lAddParam, lAddParams.get(lAddParam)));
                }
            }
            return EXIT_OK;
        }
        long lStartTime = Calendar.getInstance().getTimeInMillis();
        ArgOpt[] listOpts = new ArgOpt[]{this.runnerClassArg, this.modelArg, this.outputArg, this.allRunnersArg};
        HashMap<String, String> parameters = this.checkAndLoadParam(args, listOpts);
        if (this.validArguments) {
            this.argRunnerClass = parameters.get(RUNNER_CLASS);
            this.argModel = parameters.get(MODEL);
            this.argOutput = parameters.get(OUTPUT);
            try {
                System.out.println("Generation starting...");
                System.out.println("---------------------");
                Activator.getDefault().getLog().log((IStatus)new Status(1, "org.eclipse.gendoc.wizard", "Starting the batch mode..."));
                Activator.getDefault().getLog().log((IStatus)new Status(1, "org.eclipse.gendoc.wizard", "---------------------"));
                IGendocRunner lRunner = null;
                IGendocTemplate lTemplateToUse = null;
                for (IGendocRunner lPlatformRunner : Utils.getAllRunners()) {
                    if (!lPlatformRunner.getClass().getName().equals(this.argRunnerClass)) continue;
                    lRunner = lPlatformRunner;
                    break;
                }
                if (lRunner == null) {
                    throw new Exception("The runner [" + this.argRunnerClass + "] is not defined ");
                }
                String lExtension = this.argOutput.substring(this.argOutput.toLowerCase().lastIndexOf(".") + 1);
                if (lExtension == null) {
                    throw new Exception("You shall define the extension in output parameter");
                }
                if (lRunner.getGendocTemplates() != null) {
                    for (IGendocTemplate lTemplate : lRunner.getGendocTemplates()) {
                        if (lTemplate.getOutPutExtension() == null) {
                            throw new Exception("You shall define output extension in runner templates");
                        }
                        if (!lExtension.equals(lTemplate.getOutPutExtension())) continue;
                        lTemplateToUse = lTemplate;
                    }
                } else {
                    throw new Exception("No template defined in the runner [" + this.argRunnerClass + "]");
                }
                if (lTemplateToUse == null) {
                    throw new Exception("No template is defined for output extension [" + lExtension + "] in runner [" + this.argRunnerClass + "]");
                }
                IGendocDiagnostician diagnostician = (IGendocDiagnostician)GendocServices.getDefault().getService(IGendocDiagnostician.class);
                diagnostician.init();
                IConfigurationService parameter = (IConfigurationService)GendocServices.getDefault().getService(IConfigurationService.class);
                parameter.addParameter(lTemplateToUse.getOutputKey(), this.argOutput);
                parameter.addParameter(lTemplateToUse.getModelKey(), String.valueOf(Platform.getLocation().toFile().getPath()) + "/" + this.argModel);
                if (lRunner.getAdditionnalParameters() != null && !lRunner.getAdditionnalParameters().isEmpty()) {
                    ArgOpt[] listAddOptsTab = new ArgOpt[1];
                    for (String lParam : lRunner.getAdditionnalParameters().keySet()) {
                        listAddOptsTab[0] = new ArgOpt(lParam, 0, 1, lParam.substring(0, 2), "Additionnal param " + lParam);
                        HashMap<String, String> addParam = this.checkAndLoadParam(args, listAddOptsTab);
                        if (!this.validArguments) continue;
                        parameter.addParameter(lParam, addParam.get(lParam));
                    }
                }
                if (this.validArguments) {
                    IProgressMonitorService service = (IProgressMonitorService)GendocServices.getDefault().getService(IProgressMonitorService.class);
                    service.setMonitor((IProgressMonitor)new NullProgressMonitor());
                    GendocProcess process = new GendocProcess();
                    String resultFile = process.runProcess(lTemplateToUse.getTemplate());
                    this.handleDiagnostic(diagnostician.getResultDiagnostic(), "The file has been generated but contains errors :\n", resultFile);
                    long lEndTime = Calendar.getInstance().getTimeInMillis();
                    long lGenDuration = lEndTime - lStartTime;
                    System.out.println("Generation end (" + this.convertTime(lGenDuration) + ")");
                }
            }
            catch (Exception e) {
                System.out.println("\n$$$$$$$$$$$$$--ERROR--$$$$$$$$$$$$$");
                Activator.getDefault().getLog().log((IStatus)new Status(1, "org.eclipse.gendoc.wizard", "\n$$$$$$$$$$$$$--ERROR--$$$$$$$$$$$$$"));
                String message = " Exception occured in the generation ";
                if (e.getMessage() != null) {
                    message = String.valueOf(message) + ": " + e.getMessage();
                }
                if (e.getCause() != null) {
                    message = String.valueOf(message) + "::" + e.getCause();
                }
                System.out.println(message);
                System.out.println("$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$\n");
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.gendoc.wizard", message));
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.gendoc.wizard", "$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$\n"));
            }
        }
        this.stop();
        return EXIT_OK;
    }

    private void handleDiagnostic(Diagnostic resultDiagnostic, String message, String resultFilePath) {
        if (resultDiagnostic.getSeverity() == 0) {
            Activator.getDefault().getLog().log((IStatus)new Status(1, "org.eclipse.gendoc.wizard", "The document has been generated successfully: \n" + resultFilePath));
            System.out.println("The document has been generated successfully: \n" + resultFilePath);
        } else {
            String path = "";
            if (resultFilePath != null) {
                path = resultFilePath;
            }
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.gendoc.wizard", String.valueOf(message) + path));
            IStatus lStatus = BasicDiagnostic.toIStatus((Diagnostic)resultDiagnostic);
            Activator.getDefault().getLog().log(lStatus);
            System.out.println(String.valueOf(message) + " " + lStatus.getMessage() == null ? "" : lStatus.getMessage());
            IStatus[] iStatusArray = lStatus.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus lStatChild = iStatusArray[n2];
                System.out.println("\t" + lStatChild.getMessage());
                ++n2;
            }
        }
    }

    public void stop() {
        System.out.println("End of the generation");
        System.out.println("---------------------");
        Activator.getDefault().getLog().log((IStatus)new Status(1, "org.eclipse.gendoc.wizard", "End of the generation"));
        Activator.getDefault().getLog().log((IStatus)new Status(1, "org.eclipse.gendoc.wizard", "---------------------"));
    }

    private HashMap<String, String> checkAndLoadParam(String[] pArgs, ArgOpt[] pArgOpts) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        GetOpt getOpt = new GetOpt();
        String argFlat = getOpt.getFlatArguments(pArgs);
        if (argFlat.indexOf("--help") >= 0 || argFlat.indexOf("-h") >= 0) {
            getOpt.printHelp(pArgOpts);
            this.validArguments = false;
        } else {
            params = getOpt.getArguments(pArgOpts, pArgs);
            if (GetOpt.error == null || GetOpt.error.length() > 0) {
                System.out.println(GetOpt.error);
                this.validArguments = false;
            }
        }
        return params;
    }

    private String convertTime(long ms) {
        long seconds = (ms /= 1000L) % 60L;
        long minutes = (ms /= 60L) % 60L;
        long hours = ms /= 60L;
        return "Duration: " + hours + "h " + minutes + "min " + seconds + "s";
    }

    private void setupWorkbench() {
        PlatformUI.createAndRunWorkbench((Display)Display.getDefault(), (WorkbenchAdvisor)new WorkbenchAdvisor(){

            public String getInitialWindowPerspectiveId() {
                return "";
            }

            public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
                return null;
            }

            public IAdaptable getDefaultPageInput() {
                return null;
            }

            public String getMainPreferencePageId() {
                return "";
            }

            protected IWorkbenchConfigurer getWorkbenchConfigurer() {
                return null;
            }

            public synchronized AbstractStatusHandler getWorkbenchErrorHandler() {
                return null;
            }

            public void initialize(IWorkbenchConfigurer configurer) {
            }

            public boolean openWindows() {
                return false;
            }

            public IStatus restoreState(IMemento memento) {
                return null;
            }

            public IStatus saveState(IMemento memento) {
                return null;
            }
        });
    }
}

