/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.document.parser.xlsx;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.gendoc.document.parser.documents.AbstractZipDocument;
import org.eclipse.gendoc.document.parser.documents.Document;
import org.eclipse.gendoc.document.parser.documents.IXMLParserProvider;
import org.eclipse.gendoc.document.parser.documents.Unzipper;
import org.eclipse.gendoc.document.parser.documents.XMLParser;
import org.eclipse.gendoc.document.parser.documents.helper.OfficeHelper;
import org.eclipse.gendoc.document.parser.documents.helper.XMLHelper;
import org.eclipse.gendoc.document.parser.xlsx.XLSXParserProvider;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XLSXDocument
extends AbstractZipDocument {
    private static final String SHEET_NODE = "sheet";
    private static final String NEW_CELL_NODE = "si";
    private static final String TEXT_VALUE_NODE = "t";
    private String[] strings = null;
    private NodeList[] nodes = null;
    private HashMap<String, XMLParser> subdocuments = new HashMap();

    public XLSXDocument(File documentFile) throws IOException {
        this(documentFile.toURI().toURL(), null);
    }

    public XLSXDocument(File documentFile, Map<Document.CONFIGURATION, Boolean> configuration) throws IOException {
        this(documentFile.toURI().toURL(), configuration);
    }

    public XLSXDocument(URL documentFile, Map<Document.CONFIGURATION, Boolean> configuration) {
        super(documentFile, configuration);
    }

    public String getSharedString(int ref) {
        if (ref < 0 || ref > this.strings.length) {
            throw new IllegalArgumentException("Shared String with index '" + ref + "' does not exists.");
        }
        return this.strings[ref];
    }

    public NodeList getSharedStringNodes(int ref) {
        if (ref < 0 || ref > this.strings.length) {
            throw new IllegalArgumentException("Shared String with index '" + ref + "' does not exists.");
        }
        return this.nodes[ref];
    }

    private void initStrings() {
        XMLParser parser = new XMLParser(this.getUnzipper().getFile("sharedStrings.xml"));
        Node item = parser.getCurrentNode().getAttributes().getNamedItem("uniqueCount");
        if (item == null) {
            return;
        }
        int nb = Integer.valueOf(item.getTextContent());
        this.strings = new String[nb];
        this.nodes = new NodeList[nb];
        int i = -1;
        do {
            String nodeName;
            if (NEW_CELL_NODE.equals(nodeName = parser.getCurrentNode().getNodeName())) {
                this.nodes[++i] = parser.getCurrentNode().getChildNodes();
            }
            if (!TEXT_VALUE_NODE.equals(nodeName)) continue;
            String text = parser.getCurrentNode().getTextContent();
            this.strings[i] = this.strings[i] != null ? this.strings[i].concat(text) : text;
        } while (parser.next());
    }

    protected Collection<XMLParser> getXmlParsers(Document.CONFIGURATION idForDocument) {
        if (this.strings == null) {
            this.initStrings();
        }
        LinkedList<XMLParser> parsers = new LinkedList<XMLParser>();
        switch (idForDocument) {
            case content: {
                XLSXParserProvider provider = new XLSXParserProvider(this);
                XMLParser workbook = new XMLParser(this.getUnzipper().getFile("workbook.xml"), idForDocument);
                do {
                    Node item;
                    if (!SHEET_NODE.equals(workbook.getCurrentNode().getNodeName()) || (item = workbook.getCurrentNode().getAttributes().getNamedItem("r:id")) == null) continue;
                    OfficeHelper.fillCollection((Unzipper)this.getUnzipper(), (IXMLParserProvider)provider, parsers, (String)"http://schemas.openxmlformats.org/officeDocument/2006/relationships/worksheet", (Document.CONFIGURATION)idForDocument, (String)"workbook.xml.rels", (String)item.getTextContent());
                } while (workbook.next());
                break;
            }
            case footer: {
                break;
            }
        }
        return parsers;
    }

    public String getNextDocumentName(String relpath) {
        File rel = new File(relpath.replace("/", File.separator));
        String[] nameParts = rel.getName().split("\\*");
        File f = new File(this.getUnzipLocationDocumentFile(), rel.getPath());
        File folder = f.getParentFile();
        int index = 0;
        if (folder.exists()) {
            String[] names = folder.list();
            int i = 0;
            while (names != null && i < names.length) {
                if (names[i].startsWith(nameParts[0]) && names[i].endsWith(nameParts[1])) {
                    try {
                        index = Math.max(Integer.valueOf(names[i].replace(nameParts[0], "").replace(nameParts[1], "")), index);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                ++i;
            }
        }
        String res = String.valueOf(rel.getParent()) + File.separator + rel.getName().replace("*", String.valueOf(index + 1));
        return res.replace(File.separator, "/");
    }

    public XMLParser createSubdocument(String path, CharSequence content) throws IOException {
        File f = new File(this.getUnzipLocationDocumentFile(), path.replace("/", File.separator));
        f.getParentFile().mkdirs();
        FileWriter writer = new FileWriter(f);
        writer.write(content.toString());
        writer.flush();
        writer.close();
        return this.getSubdocument(path);
    }

    public Collection<XMLParser> getSubdocuments() {
        return this.subdocuments == null ? Collections.emptyList() : this.subdocuments.values();
    }

    public XMLParser getSubdocument(String relpath) {
        XMLParser p;
        if (this.subdocuments == null) {
            this.subdocuments = new HashMap();
        }
        if (!(relpath = relpath.replace(File.separatorChar, '/')).startsWith("/")) {
            relpath = "/" + relpath;
        }
        if ((p = this.subdocuments.get(relpath)) != null) {
            return p;
        }
        File f = new File(this.getUnzipLocationDocumentFile(), relpath.replace("/", File.separator));
        if (f.exists()) {
            p = new XMLParser(f);
            this.subdocuments.put(relpath, p);
        }
        return p;
    }

    public String getStyle() {
        return "";
    }

    public String getText() {
        Node node = this.getXMLParser().getCurrentNode();
        if ("row".equals(node.getNodeName())) {
            StringBuffer buf = new StringBuffer();
            this.getTextRow(node, buf);
            return buf.toString();
        }
        if ("c".equals(node.getNodeName())) {
            StringBuffer buf = new StringBuffer();
            this.getTextCell(node, buf);
            return buf.toString();
        }
        return "";
    }

    public Node getTextRow(Node n, StringBuffer buf) {
        n = XMLHelper.next((Node)n);
        while (n != null && "c".equals(n.getNodeName())) {
            n = this.getTextCell(n, buf);
        }
        return n;
    }

    public Node getTextCell(Node n, StringBuffer buf) {
        String result = "";
        Node item = n.getAttributes().getNamedItem(TEXT_VALUE_NODE);
        n = XMLHelper.next((Node)n);
        while (n != null) {
            if ("v".equals(n.getNodeName())) {
                String value = n.getTextContent();
                if (item != null && "s".equals(item.getTextContent())) {
                    try {
                        int index = Integer.valueOf(value);
                        if (index >= this.strings.length) break;
                        result = this.strings[index];
                    }
                    catch (NumberFormatException numberFormatException) {}
                    break;
                }
                result = value;
                break;
            }
            if ("is".equals(n.getNodeName())) {
                Node is = n;
                n = XMLHelper.next((Node)n);
                StringBuffer s = new StringBuffer("");
                while (n != null && XMLHelper.isAncestor((Node)n, (Node)is)) {
                    if (TEXT_VALUE_NODE.equals(n.getNodeName())) {
                        s.append(n.getTextContent());
                    }
                    n = XMLHelper.next((Node)n);
                }
                result = s.toString();
                break;
            }
            if ("row".equals(n.getNodeName()) || "c".equals(n.getNodeName())) break;
            n = XMLHelper.next((Node)n);
        }
        buf.append(result.replace("\n", ""));
        return n;
    }

    public String getTextCorrespondingToCurrentStyle() {
        return null;
    }

    public int getColumnNumber() {
        String[] columnArray;
        Node item;
        int column = -1;
        Node currentNode = this.getXMLParser().getCurrentNode();
        if ("c".equals(currentNode.getNodeName()) && (item = currentNode.getAttributes().getNamedItem("r")) != null && (columnArray = item.getTextContent().split("\\d")).length > 0) {
            String columnString = columnArray[0];
            column = this.getColumnNumber(columnString);
        }
        return column;
    }

    private int getColumnNumber(String columnString) {
        if (columnString == null || columnString.length() == 0) {
            return -1;
        }
        int finalValue = 0;
        int j = 0;
        int i = columnString.length() - 1;
        while (i >= 0) {
            finalValue = (int)((double)finalValue + (double)this.getColumnNumber(columnString.charAt(i)) * Math.pow(26.0, j));
            ++j;
            --i;
        }
        return finalValue - 1;
    }

    private int getColumnNumber(char charAt) {
        return charAt - 65 + 1;
    }

    public Object get(Document.PROPERTY property) {
        switch (property) {
            case row: {
                return this.getRowNumber();
            }
            case column: {
                return this.getColumnNumber();
            }
            case text: {
                return this.getText();
            }
        }
        return null;
    }

    private int getRowNumber() {
        return 0;
    }
}

