/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.example.workflow.launch;

import java.io.IOException;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.eclipse.elk.alg.layered.options.LayeredMetaDataProvider;
import org.eclipse.elk.core.data.ILayoutMetaDataProvider;
import org.eclipse.glsp.example.workflow.WorkflowGLSPModule;
import org.eclipse.glsp.example.workflow.launch.WorkflowCLIParser;
import org.eclipse.glsp.layout.ElkLayoutEngine;
import org.eclipse.glsp.server.di.GLSPModule;
import org.eclipse.glsp.server.launch.DefaultCLIParser;
import org.eclipse.glsp.server.launch.DefaultGLSPServerLauncher;
import org.eclipse.glsp.server.utils.LaunchUtil;
import org.eclipse.glsp.server.websocket.WebsocketServerLauncher;

public final class WorkflowServerLauncher {
    private WorkflowServerLauncher() {
    }

    public static void main(String[] args) {
        String processName = "WorkflowExampleGlspServer";
        try {
            WorkflowCLIParser parser = new WorkflowCLIParser(args, processName);
            LaunchUtil.configure((DefaultCLIParser)parser);
            ElkLayoutEngine.initialize((ILayoutMetaDataProvider[])new ILayoutMetaDataProvider[]{new LayeredMetaDataProvider()});
            int port = parser.parsePort();
            WebsocketServerLauncher launcher = parser.isWebsocket() ? new WebsocketServerLauncher((GLSPModule)new WorkflowGLSPModule(), "/workflow") : new DefaultGLSPServerLauncher((GLSPModule)new WorkflowGLSPModule());
            launcher.start("localhost", port);
        }
        catch (IOException | ParseException ex) {
            ex.printStackTrace();
            System.out.println();
            LaunchUtil.printHelp((String)processName, (Options)WorkflowCLIParser.getDefaultOptions());
        }
    }
}

