/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.example.workflow.utils;

import java.util.Map;
import org.eclipse.glsp.example.workflow.wfgraph.ActivityNode;
import org.eclipse.glsp.example.workflow.wfgraph.Icon;
import org.eclipse.glsp.example.workflow.wfgraph.TaskNode;
import org.eclipse.glsp.example.workflow.wfgraph.WeightedEdge;
import org.eclipse.glsp.example.workflow.wfgraph.WfgraphFactory;
import org.eclipse.glsp.graph.GCompartment;
import org.eclipse.glsp.graph.GEdge;
import org.eclipse.glsp.graph.GLabel;
import org.eclipse.glsp.graph.GModelElement;
import org.eclipse.glsp.graph.GNode;
import org.eclipse.glsp.graph.builder.AbstractGCompartmentBuilder;
import org.eclipse.glsp.graph.builder.AbstractGEdgeBuilder;
import org.eclipse.glsp.graph.builder.AbstractGNodeBuilder;
import org.eclipse.glsp.graph.builder.impl.GCompartmentBuilder;
import org.eclipse.glsp.graph.builder.impl.GLabelBuilder;
import org.eclipse.glsp.graph.builder.impl.GLayoutOptions;

public final class WorkflowBuilder {
    private WorkflowBuilder() {
    }

    public static class ActivityNodeBuilder
    extends AbstractGNodeBuilder<ActivityNode, ActivityNodeBuilder> {
        protected String nodeType;

        public ActivityNodeBuilder(String type, String nodeType) {
            super(type);
            this.nodeType = nodeType;
        }

        protected void setProperties(ActivityNode node) {
            super.setProperties((GNode)node);
            node.setNodeType(this.nodeType);
        }

        protected ActivityNode instantiate() {
            return WfgraphFactory.eINSTANCE.createActivityNode();
        }

        protected ActivityNodeBuilder self() {
            return this;
        }
    }

    public static class IconBuilder
    extends AbstractGCompartmentBuilder<Icon, IconBuilder> {
        public IconBuilder() {
            super("icon");
        }

        protected Icon instantiate() {
            return WfgraphFactory.eINSTANCE.createIcon();
        }

        protected IconBuilder self() {
            return this;
        }
    }

    public static class TaskNodeBuilder
    extends AbstractGNodeBuilder<TaskNode, TaskNodeBuilder> {
        private final String name;
        private final String taskType;
        private final int duration;

        public TaskNodeBuilder(String type, String name, String taskType, int duration) {
            super(type);
            this.name = name;
            this.taskType = taskType;
            this.duration = duration;
        }

        protected TaskNode instantiate() {
            return WfgraphFactory.eINSTANCE.createTaskNode();
        }

        protected TaskNodeBuilder self() {
            return this;
        }

        public void setProperties(TaskNode taskNode) {
            super.setProperties((GNode)taskNode);
            taskNode.setName(this.name);
            taskNode.setTaskType(this.taskType);
            taskNode.setDuration(this.duration);
            taskNode.setLayout("vbox");
            taskNode.getChildren().add((Object)this.createCompartment(taskNode));
        }

        private GCompartment createCompartment(TaskNode taskNode) {
            return (GCompartment)((GCompartmentBuilder)((GCompartmentBuilder)((GCompartmentBuilder)((GCompartmentBuilder)new GCompartmentBuilder("comp:header").id(String.valueOf(taskNode.getId()) + "_header")).layout("hbox")).add((GModelElement)this.createCompartmentIcon(taskNode))).add((GModelElement)this.createCompartmentHeader(taskNode))).build();
        }

        private GLabel createCompartmentHeader(TaskNode taskNode) {
            return (GLabel)((GLabelBuilder)((GLabelBuilder)new GLabelBuilder("label:heading").id(String.valueOf(taskNode.getId()) + "_classname")).text(taskNode.getName())).build();
        }

        private Icon createCompartmentIcon(TaskNode taskNode) {
            return (Icon)((IconBuilder)((IconBuilder)((IconBuilder)((IconBuilder)new IconBuilder().id(String.valueOf(taskNode.getId()) + "_icon")).layout("stack")).layoutOptions((Map)new GLayoutOptions().hAlign("center").resizeContainer(false))).add((GModelElement)this.createCompartmentIconLabel(taskNode))).build();
        }

        private GLabel createCompartmentIconLabel(TaskNode taskNode) {
            return (GLabel)((GLabelBuilder)((GLabelBuilder)new GLabelBuilder("label:icon").id(String.valueOf(taskNode.getId()) + "_ticon")).text("" + taskNode.getTaskType().toUpperCase().charAt(0))).build();
        }
    }

    public static class WeightedEdgeBuilder
    extends AbstractGEdgeBuilder<WeightedEdge, WeightedEdgeBuilder> {
        private String probability;

        public WeightedEdgeBuilder() {
            super("edge:weighted");
        }

        public WeightedEdgeBuilder probability(String probability) {
            this.probability = probability;
            return this.self();
        }

        protected void setProperties(WeightedEdge edge) {
            super.setProperties((GEdge)edge);
            edge.setProbability(this.probability);
        }

        protected WeightedEdge instantiate() {
            return WfgraphFactory.eINSTANCE.createWeightedEdge();
        }

        protected WeightedEdgeBuilder self() {
            return this;
        }
    }
}

