/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.example.workflow.labeledit;

import com.google.inject.Inject;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.glsp.example.workflow.wfgraph.TaskNode;
import org.eclipse.glsp.graph.GLabel;
import org.eclipse.glsp.graph.GModelElement;
import org.eclipse.glsp.server.features.directediting.LabelEditValidator;
import org.eclipse.glsp.server.features.directediting.ValidationStatus;
import org.eclipse.glsp.server.model.GModelState;

public class WorkflowLabelEditValidator
implements LabelEditValidator {
    @Inject
    protected GModelState modelState;

    public ValidationStatus validate(String label, GModelElement element) {
        if (label.length() < 1) {
            return ValidationStatus.error((String)"Name must not be empty");
        }
        Set taskNodes = this.modelState.getIndex().getAllByClass(TaskNode.class);
        Stream<GLabel> otherLabels = taskNodes.stream().filter(e -> !e.getId().equals(element.getId())).flatMap(n -> n.getChildren().stream()).filter(c -> "label:heading".equals(c.getType())).filter(GLabel.class::isInstance).map(GLabel.class::cast);
        boolean hasDuplicate = otherLabels.anyMatch(otherLabel -> label.equals(otherLabel.getText()));
        if (hasDuplicate) {
            return ValidationStatus.warning((String)"Name should be unique");
        }
        return ValidationStatus.ok();
    }
}

