/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.emf.notation;

import com.google.inject.Inject;
import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.glsp.graph.GModelElement;
import org.eclipse.glsp.graph.GModelIndex;
import org.eclipse.glsp.graph.GModelRoot;
import org.eclipse.glsp.server.emf.EMFModelState;
import org.eclipse.glsp.server.emf.model.notation.Diagram;
import org.eclipse.glsp.server.emf.notation.EMFNotationModelIndex;
import org.eclipse.glsp.server.emf.notation.EMFSemanticIdConverter;
import org.eclipse.glsp.server.session.ClientSession;

public class EMFNotationModelState
extends EMFModelState {
    protected Diagram notationModel;
    protected EObject semanticModel;
    @Inject
    protected EMFSemanticIdConverter semanticIdConverter;

    @Override
    protected GModelIndex getOrUpdateIndex(GModelRoot newRoot) {
        return EMFNotationModelIndex.getOrCreate((GModelElement)this.getRoot(), this.semanticIdConverter);
    }

    @Override
    public EMFNotationModelIndex getIndex() {
        return (EMFNotationModelIndex)super.getIndex();
    }

    public void setSemanticModel(EObject semanticModel) {
        this.semanticModel = semanticModel;
    }

    public EObject getSemanticModel() {
        return this.semanticModel;
    }

    public <T extends EObject> Optional<T> getSemanticModel(Class<T> clazz) {
        return Optional.ofNullable(this.semanticModel).filter(clazz::isInstance).map(clazz::cast);
    }

    public void setNotationModel(Diagram notationModel) {
        this.notationModel = notationModel;
    }

    public Diagram getNotationModel() {
        return this.notationModel;
    }

    public <T extends Diagram> Optional<T> getNotationModel(Class<T> clazz) {
        return Optional.ofNullable(this.notationModel).filter(clazz::isInstance).map(clazz::cast);
    }

    @Override
    public void sessionDisposed(ClientSession clientSession) {
        this.semanticModel = null;
        this.notationModel = null;
        super.sessionDisposed(clientSession);
    }
}

