/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.features.validation;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.glsp.graph.GModelElement;
import org.eclipse.glsp.graph.GModelIndex;
import org.eclipse.glsp.graph.GModelRoot;
import org.eclipse.glsp.server.actions.AbstractActionHandler;
import org.eclipse.glsp.server.actions.Action;
import org.eclipse.glsp.server.features.validation.Marker;
import org.eclipse.glsp.server.features.validation.ModelValidator;
import org.eclipse.glsp.server.features.validation.RequestMarkersAction;
import org.eclipse.glsp.server.features.validation.SetMarkersAction;
import org.eclipse.glsp.server.model.GModelState;

public class RequestMarkersHandler
extends AbstractActionHandler<RequestMarkersAction> {
    private static final Logger LOGGER = LogManager.getLogger(RequestMarkersHandler.class);
    @Inject
    protected Optional<ModelValidator> validator;
    @Inject
    protected GModelState modelState;

    @Override
    public List<Action> executeAction(RequestMarkersAction action) {
        List<String> elementsIDs = action.getElementsIDs();
        if (this.validator.isEmpty()) {
            LOGGER.warn("Cannot compute markers! No implementation for " + ModelValidator.class + " has been bound");
            return this.none();
        }
        if (elementsIDs == null || elementsIDs.size() == 0 || elementsIDs.size() == 1 && "EMPTY".equals(elementsIDs.get(0))) {
            elementsIDs = Arrays.asList(((GModelRoot)this.modelState.getRoot()).getId());
        }
        ArrayList<Marker> markers = new ArrayList<Marker>();
        GModelIndex currentModelIndex = this.modelState.getIndex();
        for (String elementID : elementsIDs) {
            Optional modelElement = currentModelIndex.get(elementID);
            if (!modelElement.isPresent()) continue;
            markers.addAll(this.validator.get().validate((GModelElement)modelElement.get()));
        }
        return this.listOf(new SetMarkersAction(markers));
    }
}

