/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.features.toolpalette;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.glsp.server.actions.TriggerElementCreationAction;
import org.eclipse.glsp.server.features.directediting.LabeledAction;

public class PaletteItem
extends LabeledAction {
    private String id;
    private String sortString;
    private List<PaletteItem> children;

    public PaletteItem(String id, String label) {
        super(label, Collections.emptyList());
        this.id = id;
        this.sortString = "" + label.charAt(0);
    }

    public PaletteItem(String id, String label, TriggerElementCreationAction initalizeAction) {
        this(id, label, initalizeAction, null);
    }

    public PaletteItem(String id, String label, TriggerElementCreationAction initalizeAction, String icon) {
        super(label, Arrays.asList(initalizeAction), icon);
        this.id = id;
        this.sortString = "" + label.charAt(0);
    }

    public PaletteItem(String id, String label, TriggerElementCreationAction initalizeAction, String icon, String sortString) {
        super(label, Arrays.asList(initalizeAction), icon);
        this.id = id;
        this.sortString = sortString;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getSortString() {
        return this.sortString;
    }

    public void setSortString(String sortString) {
        this.sortString = sortString;
    }

    public List<PaletteItem> getChildren() {
        return this.children;
    }

    public void setChildren(List<PaletteItem> children) {
        this.children = children;
    }

    public static PaletteItem createPaletteGroup(String id, String label, List<PaletteItem> children) {
        PaletteItem item = new PaletteItem(id, label);
        item.setChildren(children);
        return item;
    }

    public static PaletteItem createPaletteGroup(String id, String label, List<PaletteItem> children, String icon) {
        PaletteItem item = new PaletteItem(id, label);
        item.setChildren(children);
        item.setIcon(icon);
        return item;
    }

    public static PaletteItem createPaletteGroup(String id, String label, List<PaletteItem> children, String icon, String sortString) {
        PaletteItem item = new PaletteItem(id, label);
        item.setChildren(children);
        item.setIcon(icon);
        item.setSortString(sortString);
        return item;
    }
}

