/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.internal.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.glsp.server.types.GLSPServerException;

public final class GenericsUtil {
    private GenericsUtil() {
    }

    public static ParameterizedType getParametrizedType(Class<?> clazz, Class<?> genericBaseclass) {
        if (clazz.getSuperclass().equals(genericBaseclass)) {
            return (ParameterizedType)clazz.getGenericSuperclass();
        }
        return GenericsUtil.getParametrizedType(clazz.getSuperclass(), genericBaseclass);
    }

    public static Class<?> getGenericTypeParameterClass(Class<?> clazz, Class<?> genericBaseclass) {
        return (Class)GenericsUtil.getParametrizedType(clazz, genericBaseclass).getActualTypeArguments()[0];
    }

    public static <T> Optional<? extends T> asActualTypeArgument(Class<?> clazz, Class<T> baseType, Object typeObject) {
        return GenericsUtil.findActualTypeArgument(clazz, baseType).filter(matchingType -> matchingType.isInstance(typeObject)).map(matchingType -> matchingType.cast(typeObject));
    }

    public static <T> Class<? extends T> getActualTypeArgument(Class<?> clazz, Class<T> baseType) {
        return GenericsUtil.findActualTypeArgument(clazz, baseType).orElseThrow(() -> new GLSPServerException("No matching type argument for " + baseType + " in " + clazz));
    }

    public static <T> Optional<Class<? extends T>> findActualTypeArgument(Class<?> clazz, Class<T> baseType) {
        return GenericsUtil.findActualTypeArgument(clazz, baseType, null);
    }

    public static <T> Optional<Class<? extends T>> findActualTypeArgument(Class<?> clazz, Class<T> baseType, Class<?> searchStop) {
        if (clazz == null || baseType == null) {
            return Optional.empty();
        }
        if (clazz.getGenericSuperclass() instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)clazz.getGenericSuperclass();
            Type[] typeArray = parameterizedType.getActualTypeArguments();
            int n = typeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Type typeArgument = typeArray[n2];
                if (typeArgument instanceof Class && baseType.isAssignableFrom((Class)typeArgument)) {
                    return Optional.of((Class)typeArgument);
                }
                ++n2;
            }
        }
        return clazz.getSuperclass() == null || Objects.equals(clazz, searchStop) ? Optional.empty() : GenericsUtil.findActualTypeArgument(clazz.getSuperclass(), baseType, searchStop);
    }
}

