/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.graph.builder;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.glsp.graph.GEdgePlacement;
import org.eclipse.glsp.graph.GNode;
import org.eclipse.glsp.graph.builder.GShapeElementBuilder;

public abstract class AbstractGNodeBuilder<T extends GNode, E extends AbstractGNodeBuilder<T, E>>
extends GShapeElementBuilder<T, E> {
    protected String layout;
    protected Map<String, Object> layoutOptions;
    protected GEdgePlacement edgePlacement;

    public AbstractGNodeBuilder(String type) {
        super(type);
    }

    public E addLayoutOptions(Map<String, Object> layoutOptions) {
        if (this.layoutOptions == null) {
            this.layoutOptions = new LinkedHashMap<String, Object>();
        }
        this.layoutOptions.putAll(layoutOptions);
        return (E)((AbstractGNodeBuilder)this.self());
    }

    public E layoutOptions(Map<String, Object> layoutOptions) {
        this.addLayoutOptions(layoutOptions);
        return (E)((AbstractGNodeBuilder)this.self());
    }

    public E edgePlacement(GEdgePlacement edgePlacement) {
        this.edgePlacement = edgePlacement;
        return (E)((AbstractGNodeBuilder)this.self());
    }

    public E layout(String layout) {
        this.layout = layout;
        return (E)((AbstractGNodeBuilder)this.self());
    }

    public E layout(String layout, Map<String, Object> layoutOptions) {
        this.layout = layout;
        this.addLayoutOptions(layoutOptions);
        return (E)((AbstractGNodeBuilder)this.self());
    }

    @Override
    protected void setProperties(T node) {
        super.setProperties(node);
        node.setLayout(this.layout);
        if (this.layout != null && this.layoutOptions != null) {
            node.getLayoutOptions().putAll(this.layoutOptions);
        }
        node.setEdgePlacement(this.edgePlacement);
    }
}

