/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.emf.notation;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.glsp.graph.GModelRoot;
import org.eclipse.glsp.graph.builder.impl.GEdgeBuilder;
import org.eclipse.glsp.graph.builder.impl.GNodeBuilder;
import org.eclipse.glsp.server.emf.EMFGModelFactory;
import org.eclipse.glsp.server.emf.model.notation.Diagram;
import org.eclipse.glsp.server.emf.model.notation.Edge;
import org.eclipse.glsp.server.emf.model.notation.Shape;
import org.eclipse.glsp.server.emf.notation.EMFNotationModelState;
import org.eclipse.glsp.server.emf.notation.util.NotationUtil;

public abstract class EMFNotationGModelFactory
extends EMFGModelFactory {
    @Inject
    protected EMFNotationModelState modelState;

    @Override
    protected void fillRootElement(GModelRoot newRoot) {
        Diagram notationModel = this.modelState.getNotationModel();
        EObject semanticModel = this.modelState.getSemanticModel();
        this.modelState.getIndex().indexAll(notationModel, semanticModel);
        this.fillRootElement(semanticModel, notationModel, newRoot);
    }

    protected abstract void fillRootElement(EObject var1, Diagram var2, GModelRoot var3);

    protected GNodeBuilder applyShapeData(EObject shapeElement, GNodeBuilder builder) {
        this.modelState.getIndex().getNotation(shapeElement, Shape.class).ifPresent(shape -> {
            GNodeBuilder gNodeBuilder2 = NotationUtil.applyShapeData(shape, builder);
        });
        return builder;
    }

    protected GEdgeBuilder applyEdgeData(EObject edgeElement, GEdgeBuilder builder) {
        this.modelState.getIndex().getNotation(edgeElement, Edge.class).ifPresent(edge -> {
            GEdgeBuilder gEdgeBuilder2 = NotationUtil.applyEdgeData(edge, builder);
        });
        return builder;
    }
}

