/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.example.workflow;

import java.util.Optional;
import org.eclipse.glsp.example.workflow.wfgraph.TaskNode;
import org.eclipse.glsp.graph.GBounds;
import org.eclipse.glsp.graph.GHtmlRoot;
import org.eclipse.glsp.graph.GModelElement;
import org.eclipse.glsp.graph.GPreRenderedElement;
import org.eclipse.glsp.graph.builder.impl.GHtmlRootBuilder;
import org.eclipse.glsp.graph.builder.impl.GPreRenderedElementBuilder;
import org.eclipse.glsp.server.features.popup.PopupModelFactory;
import org.eclipse.glsp.server.features.popup.RequestPopupModelAction;

public class WorkflowPopupFactory
implements PopupModelFactory {
    private static final String NL = "<br/>";

    private String generateTitle(TaskNode task) {
        return task.getName();
    }

    private String generateBody(TaskNode task) {
        return String.format("<br/>Type: %s<br/>Duration: %s<br/> Reference: %s<br/>", task.getTaskType(), task.getDuration(), task.getReference());
    }

    public Optional<GHtmlRoot> createPopupModel(GModelElement element, RequestPopupModelAction action) {
        if (element != null && element instanceof TaskNode) {
            TaskNode task = (TaskNode)element;
            GBounds bounds = action.getBounds();
            GPreRenderedElement popupTitle = (GPreRenderedElement)((GPreRenderedElementBuilder)((GPreRenderedElementBuilder)new GPreRenderedElementBuilder().id("popup-title")).code("<div class=\"sprotty-popup-title\">" + this.generateTitle(task) + "</div>")).build();
            GPreRenderedElement popupBody = (GPreRenderedElement)((GPreRenderedElementBuilder)((GPreRenderedElementBuilder)new GPreRenderedElementBuilder().id("popup-body")).code("<div class=\"sprotty-popup-body\">" + this.generateBody(task) + "</div>")).build();
            GHtmlRoot root = (GHtmlRoot)((GHtmlRootBuilder)((GHtmlRootBuilder)((GHtmlRootBuilder)((GHtmlRootBuilder)new GHtmlRootBuilder().canvasBounds(bounds)).id("sprotty-popup")).add((GModelElement)popupTitle)).add((GModelElement)popupBody)).build();
            return Optional.of(root);
        }
        return Optional.empty();
    }
}

