/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.markup.serializer;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.docs.intent.markup.markup.Formatting;
import org.eclipse.mylyn.docs.intent.markup.markup.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TextSerializer {
    public static final char TILDE_SYMBOL = '~';

    private TextSerializer() {
    }

    public static String render(Text textElement) {
        String renderedText = "";
        List<Formatting> formatsToBegin = TextSerializer.calculateFormatToBegin(textElement);
        List<Formatting> formatsToEnd = TextSerializer.calculateFormatToEnd(textElement);
        for (Formatting format : formatsToBegin) {
            renderedText = String.valueOf(renderedText) + TextSerializer.printFormat(format);
        }
        renderedText = String.valueOf(renderedText) + textElement.getData();
        String renderedFormatsToEndPrioritary = "";
        String renderedFormatsToEndSecondary = "";
        for (Formatting format : formatsToEnd) {
            if (formatsToBegin.contains((Object)format)) {
                renderedFormatsToEndPrioritary = String.valueOf(TextSerializer.printFormat(format)) + renderedFormatsToEndPrioritary;
                continue;
            }
            renderedFormatsToEndSecondary = String.valueOf(TextSerializer.printFormat(format)) + renderedFormatsToEndSecondary;
        }
        renderedText = String.valueOf(renderedText) + renderedFormatsToEndPrioritary + renderedFormatsToEndSecondary;
        if (textElement.isLineBreak()) {
            renderedText = String.valueOf(renderedText) + "\n";
        }
        return renderedText;
    }

    private static String printFormat(Formatting format) {
        String result = "";
        switch (format.getValue()) {
            case 1: {
                result = "_";
                break;
            }
            case 2: {
                result = "*";
                break;
            }
            case 3: {
                result = "__";
                break;
            }
            case 4: {
                result = "**";
                break;
            }
            case 5: {
                result = "??";
                break;
            }
            case 6: {
                result = "-";
                break;
            }
            case 7: {
                result = "+";
                break;
            }
            case 8: {
                result = "^";
                break;
            }
            case 9: {
                result = Character.toString('~');
                break;
            }
            case 10: {
                result = "%";
                break;
            }
            case 11: {
                result = "@";
                break;
            }
            case 12: {
                result = "@";
                break;
            }
            case 13: {
                result = "+";
                break;
            }
            case 14: {
                result = "??";
                break;
            }
        }
        return result;
    }

    private static List<Formatting> calculateFormatToBegin(Text textElement) {
        EList<Formatting> formatList = textElement.getFormat();
        ArrayList<Formatting> result = new ArrayList<Formatting>();
        Text previousText = TextSerializer.getPreviousText(textElement);
        if (previousText == null) {
            return formatList;
        }
        for (Formatting format : formatList) {
            if (previousText.getFormat().contains((Object)format)) continue;
            result.add(format);
        }
        return result;
    }

    private static List<Formatting> calculateFormatToEnd(Text textElement) {
        EList<Formatting> formatList = textElement.getFormat();
        ArrayList<Formatting> result = new ArrayList<Formatting>();
        Text nextText = TextSerializer.getNextText(textElement);
        if (nextText == null) {
            return formatList;
        }
        for (Formatting format : formatList) {
            if (nextText.getFormat().contains((Object)format)) continue;
            result.add(format);
        }
        return result;
    }

    private static Text getPreviousText(Text textElement) {
        Text previousText = null;
        ArrayList blockContent = new ArrayList(textElement.eContainer().eContents());
        int indiceTextElement = blockContent.indexOf(textElement);
        if (indiceTextElement != -1) {
            ListIterator possibleNeighbours = blockContent.listIterator(indiceTextElement);
            while (possibleNeighbours.hasPrevious()) {
                EObject possibleNeighbour = (EObject)possibleNeighbours.previous();
                if (!(possibleNeighbour instanceof Text)) continue;
                previousText = (Text)possibleNeighbour;
                break;
            }
        }
        return previousText;
    }

    private static Text getNextText(Text textElement) {
        Text nextText = null;
        EObject container = textElement.eContainer();
        EList blockContent = container.eContents();
        ListIterator possibleNeighbours = blockContent.listIterator(blockContent.indexOf((Object)textElement));
        if (possibleNeighbours.hasNext()) {
            possibleNeighbours.next();
        }
        while (possibleNeighbours.hasNext()) {
            EObject possibleNeighbour = (EObject)possibleNeighbours.next();
            if (!(possibleNeighbour instanceof Text)) continue;
            nextText = (Text)possibleNeighbour;
            break;
        }
        return nextText;
    }
}

