/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.parser.internal.state;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.docs.intent.core.descriptionunit.DescriptionBloc;
import org.eclipse.mylyn.docs.intent.core.descriptionunit.DescriptionUnit;
import org.eclipse.mylyn.docs.intent.core.document.IntentDocumentFactory;
import org.eclipse.mylyn.docs.intent.core.document.IntentSection;
import org.eclipse.mylyn.docs.intent.core.document.IntentSubSectionContainer;
import org.eclipse.mylyn.docs.intent.core.genericunit.UnitInstruction;
import org.eclipse.mylyn.docs.intent.markup.markup.Block;
import org.eclipse.mylyn.docs.intent.parser.descriptionunit.DescriptionUnitParser;
import org.eclipse.mylyn.docs.intent.parser.internal.state.IntentDefaultState;
import org.eclipse.mylyn.docs.intent.parser.internal.state.IntentGenericState;
import org.eclipse.mylyn.docs.intent.parser.internal.state.SSection;
import org.eclipse.mylyn.docs.intent.parser.modelingunit.ParseException;
import org.eclipse.mylyn.docs.intent.serializer.IntentPositionManager;

public class IntentSubSectionContainerState
extends IntentDefaultState {
    private static Map<String, IntentSubSectionContainer> identifiersToSection;
    protected boolean titleCanBeSet = true;

    public IntentSubSectionContainerState(int offset, int declarationLength, IntentGenericState previous, EObject currentElement, IntentPositionManager positionManager) {
        super(offset, declarationLength, previous, currentElement, positionManager);
    }

    public IntentGenericState beginSection(int offset, int declarationLength) {
        this.titleCanBeSet = false;
        IntentSection subSection = IntentDocumentFactory.eINSTANCE.createIntentSection();
        ((IntentSubSectionContainer)this.currentElement).getIntentContent().add((Object)subSection);
        return new SSection(offset, declarationLength, (IntentGenericState)this, subSection, this.positionManager);
    }

    public IntentGenericState descriptionUnitContent(int offset, int length, String descriptionUnitContent) throws ParseException {
        int titleLength = 0;
        String descriptionUnitDescription = descriptionUnitContent;
        if (this.titleCanBeSet() && descriptionUnitContent.trim().indexOf("\n") != -1) {
            titleLength = this.createSectionTitle(offset, descriptionUnitContent) + "\n".length();
            descriptionUnitDescription = descriptionUnitDescription.trim().substring(descriptionUnitDescription.trim().indexOf("\n"));
        }
        this.titleCanBeSet = false;
        if (descriptionUnitDescription.trim().length() > 0) {
            DescriptionUnit descriptionUnit = new DescriptionUnitParser().parse(descriptionUnitDescription);
            ((IntentSubSectionContainer)this.currentElement).getIntentContent().add((Object)descriptionUnit);
            this.positionManager.setPositionForInstruction((EObject)descriptionUnit, offset + titleLength, length - titleLength);
        }
        return this;
    }

    private int createSectionTitle(int offset, String descriptionUnitContent) throws ParseException {
        String sectionTitle = descriptionUnitContent.substring(0, descriptionUnitContent.trim().indexOf("\n"));
        DescriptionUnit descriptionUnit = new DescriptionUnitParser().parse(sectionTitle.trim());
        for (UnitInstruction title : descriptionUnit.getInstructions()) {
            if (!(title instanceof DescriptionBloc)) continue;
            EList contents = ((DescriptionBloc)title).getDescriptionBloc().getContent();
            if (contents.size() != 1) {
                throw new ParseException("The title of this section isn't well formed", offset, sectionTitle.trim().length());
            }
            Block titleBlock = (Block)contents.get(0);
            this.positionManager.setPositionForInstruction((EObject)titleBlock, offset, sectionTitle.trim().length());
            ((IntentSubSectionContainer)this.currentElement).setTitle(titleBlock);
            ((IntentSubSectionContainer)this.currentElement).setFormattedTitle(this.createFormattedTitle(sectionTitle));
        }
        return sectionTitle.length();
    }

    private String createFormattedTitle(String sectionTitle) throws ParseException {
        String formattedTitle = "";
        int i = 0;
        while (i < sectionTitle.length()) {
            if (Character.isJavaIdentifierPart(sectionTitle.charAt(i))) {
                formattedTitle = String.valueOf(formattedTitle) + sectionTitle.charAt(i);
            }
            ++i;
        }
        if (identifiersToSection == null) {
            identifiersToSection = new HashMap<String, IntentSubSectionContainer>();
        }
        identifiersToSection.get(formattedTitle);
        identifiersToSection.put(formattedTitle, (IntentSubSectionContainer)this.currentElement);
        return formattedTitle;
    }

    private boolean titleCanBeSet() {
        return this.titleCanBeSet;
    }

    public IntentGenericState endStructuredElement(int offset) {
        this.positionManager.setDeclarationPositionForInstruction(this.getCurrentElement(), this.getOffset(), offset - this.getOffset(), this.getDeclarationLength());
        return this.previousState();
    }
}

