/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.analyze.ui.components;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jubula.client.analyze.internal.AnalyzeParameter;
import org.eclipse.jubula.client.analyze.ui.i18n.Messages;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AnalyzePreferenceDialog
extends Dialog {
    private Dialog m_dialog;
    private boolean m_cancelStatus = true;
    private ArrayList<Text> m_textList;
    private String m_paramValue;

    public AnalyzePreferenceDialog(Shell parentShell, List<AnalyzeParameter> parameterList) {
        super(parentShell);
        this.createAnalyzePreferenceDialog(parameterList);
    }

    public Dialog getDialog() {
        return this.m_dialog;
    }

    public void setDialog(Dialog dialog) {
        this.m_dialog = dialog;
    }

    public boolean getCancelStatus() {
        return this.m_cancelStatus;
    }

    public void setCancelStatus(Boolean cancelStatus) {
        this.m_cancelStatus = cancelStatus;
    }

    public String getParamValue() {
        return this.m_paramValue;
    }

    public void setParamValue(String paramValue) {
        this.m_paramValue = paramValue;
    }

    public Dialog createAnalyzePreferenceDialog(final List<AnalyzeParameter> parameterList) {
        if (parameterList.size() != 0) {
            Dialog dialog = new Dialog(Display.getCurrent().getActiveShell()){

                protected Control createDialogArea(Composite parent) {
                    Composite composite = (Composite)super.createDialogArea(parent);
                    AnalyzePreferenceDialog.this.createDialogContent(composite, parameterList);
                    return composite;
                }

                protected Point getInitialSize() {
                    int height = parameterList.size() <= 10 ? parameterList.size() * 32 + 132 : 452;
                    return new Point(600, height);
                }

                protected void okPressed() {
                    AnalyzePreferenceDialog.this.setCancelStatus(false);
                    AnalyzePreferenceDialog.this.getDialog().close();
                }

                protected void cancelPressed() {
                    AnalyzePreferenceDialog.this.setCancelStatus(true);
                    AnalyzePreferenceDialog.this.getDialog().close();
                }

                protected void createButtonsForButtonBar(Composite parent) {
                    ++((GridLayout)parent.getLayout()).numColumns;
                    Button defaults = new Button(parent, 8);
                    defaults.setData((Object)parameterList);
                    defaults.setText(Messages.DefaultsButton);
                    defaults.addListener(13, new Listener(){

                        public void handleEvent(Event event) {
                            AnalyzePreferenceDialog.this.restore();
                        }
                    });
                    this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
                    this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
                }

                protected void configureShell(Shell newShell) {
                    super.configureShell(newShell);
                    newShell.setText(Messages.AnalyzePreferenceDialog);
                }
            };
            this.setDialog(dialog);
            dialog.open();
            return dialog;
        }
        this.setCancelStatus(false);
        return null;
    }

    private void createDialogContent(Composite composite, List<AnalyzeParameter> parameterList) {
        int width = 580;
        int height = parameterList.size() * 28 + 40;
        composite.setLayout((Layout)new FillLayout());
        ScrolledComposite sc = new ScrolledComposite(composite, 512);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.setMinSize(width, height + 1);
        Composite content = new Composite((Composite)sc, 0);
        content.setLayout((Layout)new RowLayout());
        content.setSize(width, height);
        sc.setContent((Control)content);
        Label header = new Label(content, 0);
        header.setSize(600, 20);
        header.setText(Messages.AnalyzePreferenceDialogAdjustNote);
        RowData sepData = new RowData(600, 10);
        Label sep = new Label(content, 258);
        sep.setLayoutData((Object)sepData);
        this.processParameters(content, parameterList);
    }

    private void restore() {
        int i = 0;
        while (i < this.getTextList().size()) {
            Text t = this.getTextList().get(i);
            AnalyzeParameter ap = (AnalyzeParameter)t.getData();
            t.setText(ap.getDefaultValue());
            ++i;
        }
    }

    private Composite processParameters(Composite cmp, List<AnalyzeParameter> parameterList) {
        GridLayout grid = new GridLayout(4, false);
        Composite c = new Composite(cmp, 0);
        c.setLayout((Layout)grid);
        ArrayList<Text> textList = new ArrayList<Text>();
        this.setTextList(textList);
        int i = 0;
        while (i < parameterList.size()) {
            AnalyzeParameter aParam = parameterList.get(i);
            GridData sepData = new GridData();
            sepData.widthHint = 10;
            GridData dataLeft = new GridData(400, -1);
            dataLeft.horizontalAlignment = 0x1000000;
            GridData dataMid = new GridData(10, -1);
            GridData dataRight = new GridData(120, -1);
            dataRight.grabExcessHorizontalSpace = false;
            Label sepLab = new Label(c, 0);
            sepLab.setLayoutData((Object)sepData);
            Label nameLabel = new Label(c, 16384);
            nameLabel.setText(aParam.getName());
            nameLabel.setLayoutData((Object)dataLeft);
            Label infoLabel = new Label(c, 0);
            infoLabel.setLayoutData((Object)dataMid);
            Image im = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage();
            infoLabel.setImage(im);
            infoLabel.setToolTipText(aParam.getDescription());
            Text text = new Text(c, 2048);
            text.addListener(25, new Listener(){

                public void handleEvent(Event e) {
                    String enteredText = e.text;
                    char[] chars = new char[enteredText.length()];
                    enteredText.getChars(0, chars.length, chars, 0);
                    int i = 0;
                    while (i < chars.length) {
                        if ('0' > chars[i] || chars[i] > '9') {
                            e.doit = false;
                            return;
                        }
                        ++i;
                    }
                }
            });
            text.setLayoutData((Object)dataRight);
            text.setText(aParam.getValue());
            text.setTextLimit(20);
            text.setSize(70, 40);
            text.setData((Object)aParam);
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    Text text = (Text)e.widget;
                    AnalyzeParameter param = (AnalyzeParameter)text.getData();
                    param.setModifiedValue(text.getText());
                }
            });
            this.getTextList().add(text);
            ++i;
        }
        return c;
    }

    public List<Text> getTextList() {
        return this.m_textList;
    }

    public void setTextList(List<Text> textList) {
        this.m_textList = (ArrayList)textList;
    }
}

