/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.archive.converter;

import org.eclipse.jubula.client.archive.converter.AbstractXmlConverter;
import org.eclipse.jubula.client.archive.schema.Cap;
import org.eclipse.jubula.client.archive.schema.Category;
import org.eclipse.jubula.client.archive.schema.ParamDescription;
import org.eclipse.jubula.client.archive.schema.Project;
import org.eclipse.jubula.client.archive.schema.TestCase;

public class TreeDirectionConverter
extends AbstractXmlConverter {
    private static final int HIGHEST_MAJOR_VERSION_NUMBER = 8;
    private static final int HIGHEST_MINOR_VERSION_NUMBER = 1;
    private static final String OLD_DIRECTION_NAME = "CompSystem.Direction";
    private static final String NEW_DIRECTION_NAME = "CompSystem.TreeDirection";

    @Override
    protected boolean conversionIsNecessary(Project xml) {
        return xml.getMajorProjectVersion() <= 8 && xml.getMinorProjectVersion() <= 1;
    }

    @Override
    protected void convertImpl(Project xml) {
        for (Category c : xml.getCategoryList()) {
            this.convertCategory(c);
        }
    }

    private void convertCategory(Category cat) {
        for (Category subCat : cat.getCategoryList()) {
            this.convertCategory(subCat);
        }
        for (TestCase tc : cat.getTestcaseList()) {
            for (TestCase.Teststep ts : tc.getTeststepList()) {
                Cap cap = ts.getCap();
                if (cap == null || !cap.getComponentType().contains("Tree")) continue;
                for (ParamDescription p : cap.getParameterDescriptionList()) {
                    if (!p.getName().equals(OLD_DIRECTION_NAME)) continue;
                    p.setName(NEW_DIRECTION_NAME);
                    p.setUniqueId(NEW_DIRECTION_NAME);
                }
            }
        }
    }
}

