/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.dialogs;

import java.io.File;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.dialogs.InputDialog;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.utils.Utils;
import org.eclipse.jubula.tools.internal.exception.Assert;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class ClassPathDialog
extends InputDialog {
    private Button m_addFileButton;
    private Button m_addDirButton;
    private final WidgetSelectionListener m_selectionListener = new WidgetSelectionListener();
    private boolean m_buttonsEnabled;

    public ClassPathDialog(Shell parentShell, String title, String oldName, String message, String label, String wrongNameError, String doubleNameError, String image, String shell, boolean browseable, int maxLength, boolean browseButtonsEnabled) {
        super(parentShell, title, oldName, message, label, wrongNameError, doubleNameError, image, shell, browseable, maxLength);
        this.m_buttonsEnabled = browseButtonsEnabled;
    }

    private void installListeners() {
        this.m_addDirButton.addSelectionListener((SelectionListener)this.m_selectionListener);
        this.m_addFileButton.addSelectionListener((SelectionListener)this.m_selectionListener);
    }

    @Override
    protected void createAdditionalComponents(Composite parent) {
        new Label(parent, 0);
        this.m_addFileButton = new Button(parent, 8);
        this.m_addFileButton.setText(Messages.ClassPathDialogFile);
        GridData data = new GridData();
        data.horizontalAlignment = 3;
        data.grabExcessHorizontalSpace = true;
        this.m_addFileButton.setLayoutData((Object)data);
        this.m_addFileButton.setEnabled(this.m_buttonsEnabled);
        this.m_addDirButton = new Button(parent, 8);
        this.m_addDirButton.setText(Messages.ClassPathDialogDir);
        data = new GridData();
        data.horizontalAlignment = 3;
        this.m_addDirButton.setLayoutData((Object)data);
        this.m_addDirButton.setEnabled(this.m_buttonsEnabled);
        this.installListeners();
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Control area = super.createDialogArea(parent);
        return area;
    }

    void handleAddDirButtonEvent(DirectoryDialog directoryDialog) {
        directoryDialog.setMessage(Messages.ClassPathDialogAddDir);
        directoryDialog.setFilterPath(Utils.getLastDirPath());
        String directory = directoryDialog.open();
        if (directory != null) {
            Utils.storeLastDirPath(directoryDialog.getFilterPath());
            this.setInputFieldText(directory);
        }
    }

    void handleAddFileButtonEvent(FileDialog fileDialog) {
        fileDialog.setFilterExtensions(new String[]{"*.*"});
        fileDialog.setText(Messages.ClassPathDialogFileDialogMessage);
        fileDialog.setFilterPath(Utils.getLastDirPath());
        String directory = fileDialog.open();
        if (directory != null) {
            Utils.storeLastDirPath(fileDialog.getFilterPath());
            String concatFiles = "";
            String[] stringArray = fileDialog.getFileNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                file = String.valueOf(fileDialog.getFilterPath()) + File.separator + file + File.pathSeparator;
                concatFiles = String.valueOf(concatFiles) + file;
                ++n2;
            }
            this.setInputFieldText(concatFiles);
        }
    }

    private class WidgetSelectionListener
    extends SelectionAdapter {
        private WidgetSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object o = e.getSource();
            if (o.equals(ClassPathDialog.this.m_addDirButton)) {
                ClassPathDialog.this.handleAddDirButtonEvent(new DirectoryDialog(Plugin.getShell(), 81920));
                return;
            }
            if (o.equals(ClassPathDialog.this.m_addFileButton)) {
                ClassPathDialog.this.handleAddFileButtonEvent(new FileDialog(Plugin.getShell(), 81922));
                return;
            }
            Assert.notReached((String)(String.valueOf(Messages.EventActivatedUnknownWidget) + "(" + o + ")" + "."));
        }
    }
}

